/*
 * Decompiled with CFR 0.152.
 */
package org.project_kessel.clients.authn.oidc.client.nimbus;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Optional;
import org.project_kessel.clients.authn.oidc.client.OIDCClientCredentialsAuthenticationConfig;
import org.project_kessel.clients.authn.oidc.client.OIDCClientCredentialsMinter;

@RegisterForReflection
public class NimbusOIDCClientCredentialsMinter
extends OIDCClientCredentialsMinter {
    @Override
    public OIDCClientCredentialsMinter.BearerHeader authenticateAndRetrieveAuthorizationHeader(OIDCClientCredentialsAuthenticationConfig.OIDCClientCredentialsConfig config) throws OIDCClientCredentialsMinter.OIDCClientCredentialsMinterException {
        Issuer issuer = new Issuer(config.issuer());
        ClientID clientID = new ClientID(config.clientId());
        Secret clientSecret = new Secret(config.clientSecret());
        Optional<Scope> scope = config.scope().map(Scope::new);
        ClientCredentialsGrant clientGrant = new ClientCredentialsGrant();
        try {
            OIDCProviderMetadata providerMetadata = OIDCProviderMetadata.resolve((Issuer)issuer);
            URI tokenEndpoint = providerMetadata.getTokenEndpointURI();
            ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
            TokenRequest request = scope.isPresent() ? new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)clientGrant, scope.get()) : new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)clientGrant);
            TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)request.toHTTPRequest().send());
            if (!tokenResponse.indicatesSuccess()) {
                TokenErrorResponse errorResponse = tokenResponse.toErrorResponse();
                String code = errorResponse.getErrorObject().getCode();
                String message = errorResponse.getErrorObject().getDescription();
                throw new OIDCClientCredentialsMinter.OIDCClientCredentialsMinterException("Error requesting token from endpoint. TokenErrorResponse: code: " + code + ", message: " + message);
            }
            OIDCTokenResponse successResponse = (OIDCTokenResponse)tokenResponse.toSuccessResponse();
            BearerAccessToken bearerAccessToken = successResponse.getOIDCTokens().getBearerAccessToken();
            long lifetime = bearerAccessToken.getLifetime();
            Optional<LocalDateTime> expiryTime = NimbusOIDCClientCredentialsMinter.getExpiryDateFromExpiresIn(lifetime);
            return new OIDCClientCredentialsMinter.BearerHeader(bearerAccessToken.toAuthorizationHeader(), expiryTime);
        }
        catch (GeneralException | IOException e) {
            throw new OIDCClientCredentialsMinter.OIDCClientCredentialsMinterException("Failed to retrieve and parse OIDC well-known configuration from provider.", e);
        }
    }
}

