/*
 * Decompiled with CFR 0.152.
 */
package org.progressify.spring.processors;

import java.util.HashSet;
import java.util.Set;
import org.progressify.spring.processors.BaseProcessor;
import org.progressify.spring.processors.ConfigProcessor;
import org.progressify.spring.processors.PreCacheProcessor;
import org.progressify.spring.processors.StrategyProcessor;

public class ProcessorFactory {
    public static final String NETWORK_ONLY = "org.progressify.spring.annotations.NetworkOnly";
    public static final String NETWORK_FIRST = "org.progressify.spring.annotations.NetworkFirst";
    public static final String CACHE_ONLY = "org.progressify.spring.annotations.CacheOnly";
    public static final String CACHE_FIRST = "org.progressify.spring.annotations.CacheFirst";
    public static final String STALE_WHILE_REVALIDATE = "org.progressify.spring.annotations.StaleWhileRevalidate";
    public static final String PRECACHE = "org.progressify.spring.annotations.PreCache";
    public static final String PWA = "org.progressify.spring.annotations.PWA";
    public static Set<String> strategies = new HashSet<String>();
    public static Set<String> configs = new HashSet<String>();
    public static Set<String> precache = new HashSet<String>();
    private static StrategyProcessor sp;
    private static ConfigProcessor cp;
    private static PreCacheProcessor pp;

    public static BaseProcessor getProcessor(String name) {
        return strategies.contains(name) ? sp : (precache.contains(name) ? pp : cp);
    }

    static {
        strategies.add(NETWORK_ONLY);
        strategies.add(NETWORK_FIRST);
        strategies.add(CACHE_ONLY);
        strategies.add(CACHE_FIRST);
        strategies.add(STALE_WHILE_REVALIDATE);
        configs.add(PWA);
        precache.add(PRECACHE);
        sp = new StrategyProcessor();
        cp = new ConfigProcessor();
        pp = new PreCacheProcessor();
    }
}

