/*
 * Decompiled with CFR 0.152.
 */
package org.progressify.spring.processors;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.progressify.spring.processors.BaseProcessor;
import org.progressify.spring.processors.ConfigResult;
import org.progressify.spring.processors.Result;

public class ConfigProcessor
extends BaseProcessor {
    @Override
    public Result process(TypeElement annotation, Element element) {
        ConfigResult result = new ConfigResult();
        String thisAnnotation = annotation.toString();
        this.log.info("Processing config element : " + element.getEnclosingElement() + " : " + element.getSimpleName() + " annotated by:" + thisAnnotation);
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!thisAnnotation.equals(annotationMirror.getAnnotationType().toString())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> m = annotationMirror.getElementValues();
            Set<? extends ExecutableElement> s = m.keySet();
            for (ExecutableElement executableElement : s) {
                if ("swDirectory".equals(executableElement.getSimpleName().toString())) {
                    result.setSwDirectory(this.getValue(m, executableElement));
                    continue;
                }
                if (!"swFileName".equals(executableElement.getSimpleName().toString())) continue;
                result.setSwFileName(this.getValue(m, executableElement));
            }
        }
        return result;
    }

    private String getValue(Map m, ExecutableElement e) {
        AnnotationValue val = (AnnotationValue)m.get(e);
        return (String)val.getValue();
    }
}

