/*
 * Decompiled with CFR 0.152.
 */
package org.progressify.spring.processors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.progressify.spring.processors.Result;

public abstract class BaseProcessor {
    public Logger log = Logger.getLogger("org.progressify.spring");

    public abstract Result process(TypeElement var1, Element var2);

    protected Map<String, Object> getMemberMap(TypeElement annotation, Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String thisAnnotation = annotation.toString();
        this.log.info("Processing config element : " + element.getEnclosingElement() + " : " + element.getSimpleName() + " annotated by:" + thisAnnotation);
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!thisAnnotation.equals(annotationMirror.getAnnotationType().toString())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> valuesMap = annotationMirror.getElementValues();
            Set<? extends ExecutableElement> s = valuesMap.keySet();
            for (ExecutableElement executableElement : s) {
                String key = executableElement.getSimpleName().toString();
                AnnotationValue val = valuesMap.get(executableElement);
                Object valObject = val.getValue();
                map.put(key, valObject);
            }
        }
        return map;
    }
}

