/*
 * Decompiled with CFR 0.152.
 */
package org.progressify.spring.jsbuilder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.progressify.spring.jsbuilder.Statement;

public class Builder {
    private String directory;
    private String fileName;
    private LinkedList<Statement> statements = new LinkedList();

    public Builder(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
    }

    public Builder add(Statement stmt) {
        this.statements.add(stmt);
        return this;
    }

    public Builder addFirst(Statement stmt) {
        this.statements.addFirst(stmt);
        return this;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void flushToFile() throws IOException {
        File parent = new File(this.directory);
        if (!parent.exists()) {
            parent.mkdir();
        }
        File sw = new File(parent, this.fileName);
        FileWriter fileWriter = new FileWriter(sw);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        for (Statement s : this.statements) {
            printWriter.print(s.getJsString());
            printWriter.print("\n");
        }
        printWriter.close();
    }
}

