/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.codabar;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class CodabarLogicImpl {
    static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}};
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'n', 't', '-', '$', ':', '/', '.', '+', '*'};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;

    public CodabarLogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public CodabarLogicImpl(ChecksumMode mode, boolean displayStartStop) {
        this.checksumMode = mode;
        this.displayStartStop = displayStartStop;
    }

    protected static int getCharIndex(char ch) {
        for (int i = 0; i < CHARACTERS.length; ++i) {
            if (ch != CHARACTERS[i]) continue;
            return i;
        }
        return -1;
    }

    protected static boolean isValidChar(char ch) {
        return CodabarLogicImpl.getCharIndex(Character.toLowerCase(ch)) >= 0;
    }

    protected static boolean isStartStopChar(char ch) {
        return (ch = Character.toLowerCase(ch)) == 'a' || ch == 'b' || ch == 'c' || ch == 'd' || ch == 'e' || ch == '*' || ch == 'n' || ch == 't';
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    private int widthAt(char ch, int index) throws IllegalArgumentException {
        int chidx = CodabarLogicImpl.getCharIndex(ch = Character.toLowerCase(ch));
        if (chidx >= 0) {
            byte binary = CHARSET[chidx][index];
            return binary + 1;
        }
        throw new IllegalArgumentException("Invalid character: " + ch);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char ch) {
        ch = Character.toLowerCase(ch);
        logic.startBarGroup(BarGroup.MSG_CHARACTER, Character.toString(ch));
        for (int i = 0; i < 7; i = (int)((byte)(i + 1))) {
            int width = this.widthAt(ch, i);
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
        }
        logic.endBarGroup();
    }

    private void handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            throw new UnsupportedOperationException("No checksums are currently supported for Codabar symbols");
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE || this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            // empty if block
        }
    }

    private StringBuffer prepareMessage(String msg) {
        if (CodabarLogicImpl.isStartStopChar(msg.charAt(0)) && CodabarLogicImpl.isStartStopChar(msg.charAt(msg.length() - 1))) {
            return new StringBuffer(msg.substring(1, msg.length() - 1));
        }
        return new StringBuffer(msg);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        StringBuffer sb = new StringBuffer(msg);
        this.handleChecksum(sb);
        String effMsg = sb.toString();
        String displayMsg = this.displayStartStop ? sb.toString() : this.prepareMessage(msg).toString();
        logic.startBarcode(effMsg, displayMsg);
        for (int i = 0; i < sb.length(); ++i) {
            char ch;
            if (i > 0) {
                logic.addBar(false, 1);
            }
            if (!CodabarLogicImpl.isValidChar(ch = sb.charAt(i))) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
        }
        logic.endBarcode();
    }
}

