/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.evcustomer.customers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.customer.AbstractCustomer;
import org.powertac.evcustomer.Config;
import org.powertac.evcustomer.beans.Activity;
import org.powertac.evcustomer.beans.CarType;
import org.powertac.evcustomer.beans.ClassCar;
import org.powertac.evcustomer.beans.ClassGroup;
import org.powertac.evcustomer.beans.GroupActivity;
import org.powertac.evcustomer.beans.SocialGroup;
import org.powertac.evcustomer.customers.EvCustomer;

@ConfigurableInstance
public class EvSocialClass
extends AbstractCustomer {
    private static Logger log = LogManager.getLogger((String)EvSocialClass.class.getName());
    private RandomSeed generator;
    private Config config;
    @ConfigurableValue(valueType="Integer", description="minimum population")
    private int minCount;
    @ConfigurableValue(valueType="Integer", description="maximum population")
    private int maxCount;
    @ConfigurableValue(valueType="Double", description="probability of home charger")
    private double homeChargerProbability = 1.0;
    private ArrayList<EvCustomer> evCustomers;
    private Map<Integer, SocialGroup> groups;
    private Map<String, CarType> carTypes;
    private Map<Integer, Activity> activities;
    private Map<Integer, ClassGroup> classGroups;
    private Map<String, ClassCar> classCars;
    private int population;
    @ConfigurableValue(valueType="List", bootstrapState=true, dump=false, description="List of customer attributes")
    private ArrayList<String> customerAttributeList = null;

    public EvSocialClass() {
    }

    public EvSocialClass(String name) {
        super(name);
    }

    public void initialize() {
        super.initialize();
        log.info("Initialize " + this.name);
        this.generator = this.service.getRandomSeedRepo().getRandomSeed("EvSocialClass-" + this.name, 1L, "initialize");
        Config.recycle();
        this.config = Config.getInstance();
        this.config.configure(this.service.getServerConfiguration());
        Map<String, Collection<?>> beans = this.config.getBeans();
        this.unpackBeans(beans);
        this.evCustomers = new ArrayList();
        if (this.customerAttributeList == null) {
            this.configureForBoot(beans);
        } else {
            this.configureForSim(beans);
        }
    }

    public double getHomeChargerProbability() {
        return this.homeChargerProbability;
    }

    private void configureForBoot(Map<String, Collection<?>> beans) {
        this.customerAttributeList = new ArrayList();
        this.population = this.minCount + this.generator.nextInt(Math.abs(this.maxCount - this.minCount));
        log.info("Configuring " + this.population + " customers for class " + this.getName());
        ArrayList<SocialGroup> groupList = new ArrayList<SocialGroup>(this.groups.values());
        double cgProbability = 0.0;
        for (SocialGroup group : groupList) {
            cgProbability += this.classGroups.get(group.getId()).getProbability();
        }
        ArrayList<CarType> carList = new ArrayList<CarType>(this.carTypes.values());
        double ccProbability = 0.0;
        for (CarType car : carList) {
            ClassCar cc = this.classCars.get(car.getName());
            if (cc != null) {
                ccProbability += cc.getProbability();
                continue;
            }
            log.info("Car type {} not configured for {}", (Object)car.getName(), (Object)this.getName());
        }
        int i = 0;
        while (i < this.population) {
            SocialGroup thisGroup = this.pickGroup(groupList, cgProbability);
            ClassGroup groupDetails = this.classGroups.get(thisGroup.getId());
            String gender = "female";
            if (this.generator.nextDouble() < groupDetails.getMaleProbability()) {
                gender = "male";
            }
            CarType car = this.pickCar(carList, ccProbability);
            String customerName = String.valueOf(this.name) + "_" + i;
            String attributes = String.valueOf(thisGroup.getId()) + "." + gender + "." + car.getName() + ".x";
            this.customerAttributeList.add(attributes);
            this.instantiateCustomer(beans, thisGroup, gender, car, customerName);
            ++i;
        }
    }

    private void configureForSim(Map<String, Collection<?>> beans) {
        this.population = this.customerAttributeList.size();
        int index = 0;
        for (String description : this.customerAttributeList) {
            String[] attributes = description.split("\\.");
            SocialGroup thisGroup = this.groups.get(Integer.parseInt(attributes[0]));
            String gender = attributes[1];
            CarType car = this.carTypes.get(attributes[2]);
            this.instantiateCustomer(beans, thisGroup, gender, car, String.valueOf(this.name) + "_" + index++);
        }
        this.service.getServerConfiguration().configureNamedInstances(this.evCustomers);
    }

    private EvCustomer instantiateCustomer(Map<String, Collection<?>> beans, SocialGroup thisGroup, String gender, CarType car, String customerName) {
        EvCustomer customer = new EvCustomer(customerName);
        log.info("Adding EvCustomer " + customerName);
        this.evCustomers.add(customer);
        CustomerInfo info = customer.initialize(thisGroup, gender, this.activities, this.getGroupActivities(beans, thisGroup), car, this, this.service, this.config);
        this.addCustomerInfo(info);
        this.service.getCustomerRepo().add(info);
        return customer;
    }

    public void saveBootstrapState() {
        this.service.getServerConfiguration().saveBootstrapState(this.evCustomers);
    }

    private SocialGroup pickGroup(ArrayList<SocialGroup> groupList, double scale) {
        double picker = this.generator.nextDouble() * scale;
        for (SocialGroup group : groupList) {
            if (!((picker -= this.classGroups.get(group.getId()).getProbability()) <= 0.0)) continue;
            return group;
        }
        return groupList.get(groupList.size() - 1);
    }

    private CarType pickCar(ArrayList<CarType> carList, double scale) {
        double picker = this.generator.nextDouble() * scale;
        for (CarType car : carList) {
            ClassCar cc = this.classCars.get(car.getName());
            if (cc != null) {
                picker -= cc.getProbability();
            }
            if (!(picker <= 0.0)) continue;
            return car;
        }
        return carList.get(carList.size() - 1);
    }

    void unpackBeans(Map<String, Collection<?>> beans) {
        this.groups = new HashMap<Integer, SocialGroup>();
        for (Object thing : beans.get("SocialGroup")) {
            SocialGroup group = (SocialGroup)thing;
            this.groups.put(group.getId(), group);
        }
        this.carTypes = new LinkedHashMap<String, CarType>();
        ArrayList tmp = new ArrayList(beans.get("CarType"));
        Collections.sort(tmp, new Comparator<CarType>(){

            @Override
            public int compare(CarType o1, CarType o2) {
                return o1.getId() < o2.getId() ? -1 : (o1.getId() > o2.getId() ? 1 : 0);
            }
        });
        for (Object thing : tmp) {
            CarType car = (CarType)thing;
            this.carTypes.put(car.getName(), car);
        }
        this.activities = new HashMap<Integer, Activity>();
        for (Object thing : beans.get("Activity")) {
            Activity activity = (Activity)thing;
            this.activities.put(activity.getId(), activity);
        }
        this.classGroups = new HashMap<Integer, ClassGroup>();
        for (Object thing : beans.get("ClassGroup")) {
            ClassGroup classGroup = (ClassGroup)thing;
            if (!classGroup.getSocialClassName().equals(this.getName())) continue;
            this.classGroups.put(classGroup.getGroupId(), classGroup);
        }
        this.classCars = new HashMap<String, ClassCar>();
        for (Object thing : beans.get("ClassCar")) {
            ClassCar classCar = (ClassCar)thing;
            if (!classCar.getSocialClassName().equals(this.getName())) continue;
            this.classCars.put(classCar.getCarName(), classCar);
        }
    }

    private ArrayList<GroupActivity> getGroupActivities(Map<String, Collection<?>> beans, SocialGroup group) {
        ArrayList<GroupActivity> result = new ArrayList<GroupActivity>();
        for (Object thing : beans.get("GroupActivity")) {
            GroupActivity ga = (GroupActivity)thing;
            if (ga.getGroupId() != group.getId()) continue;
            result.add(ga);
        }
        return result;
    }

    public void evaluateTariffs(List<Tariff> tariffs) {
        for (EvCustomer customer : this.evCustomers) {
            customer.evaluateTariffs(tariffs);
        }
    }

    public void step() {
        for (EvCustomer customer : this.evCustomers) {
            customer.step(this.service.getTimeslotRepo().currentTimeslot());
        }
    }

    public String toString() {
        return this.name;
    }

    ArrayList<EvCustomer> getEvCustomers() {
        return this.evCustomers;
    }

    int getPopulation() {
        return this.population;
    }

    List<String> getCustomerAttributeList() {
        return this.customerAttributeList;
    }

    Random getGenerator() {
        return this.generator;
    }

    void setMinCount(int count) {
        this.minCount = count;
    }

    int getMinCount() {
        return this.minCount;
    }

    void setMaxCount(int count) {
        this.maxCount = count;
    }

    int getMaxCount() {
        return this.maxCount;
    }

    Map<Integer, SocialGroup> getGroups() {
        return this.groups;
    }

    Map<String, CarType> getCarTypes() {
        return this.carTypes;
    }

    Map<Integer, Activity> getActivities() {
        return this.activities;
    }

    Map<Integer, ClassGroup> getClassGroups() {
        return this.classGroups;
    }

    Map<String, ClassCar> getClassCars() {
        return this.classCars;
    }
}

