/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.evcustomer.customers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.powertac.common.CapacityProfile;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.RandomSeed;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.interfaces.CustomerServiceAccessor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.customer.AbstractCustomer;
import org.powertac.evcustomer.Config;
import org.powertac.evcustomer.beans.Activity;
import org.powertac.evcustomer.beans.CarType;
import org.powertac.evcustomer.beans.GroupActivity;
import org.powertac.evcustomer.beans.SocialGroup;
import org.powertac.evcustomer.customers.EvSocialClass;

@Domain
@ConfigurableInstance
public class EvCustomer {
    private static Logger log;
    private String name;
    private long id;
    private CustomerInfo customerInfo;
    private TariffEvaluator evaluator;
    private Config config;
    private String gender;
    private RiskAttitude riskAttitude;
    private CarType car;
    private SocialGroup socialGroup;
    private Map<Integer, Activity> activities;
    private List<GroupActivity> groupActivities;
    private int earlyWake;
    private int wakeRange;
    private int earlySleep;
    private int sleepRange;
    private Activity sleepActivity;
    private CustomerServiceAccessor service;
    private RandomSeed generator;
    private double capacityEpsilon;
    private double distanceEpsilon;
    private double epsilon;
    @ConfigurableValue(valueType="Boolean", bootstrapState=true, description="True if the customer is driving and cannot charge")
    private boolean driving;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="current charge in vehicle battery")
    private double currentCapacity;
    @ConfigurableValue(valueType="Boolean", bootstrapState=true, description="True if vehicle is currently plugged in")
    private boolean connected;
    private final int dataMapSize = 24;
    private TimeslotData[] todayMap;
    private TimeslotData[] tomorrowMap;
    private DateTimeFormatter dtf;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        EvCustomer.ajc$preClinit();
        log = LogManager.getLogger((String)EvCustomer.class.getName());
    }

    public EvCustomer(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        this.earlyWake = 5;
        this.wakeRange = 3;
        this.earlySleep = 20;
        this.sleepRange = 4;
        this.capacityEpsilon = 0.01;
        this.distanceEpsilon = 0.1;
        this.epsilon = 1.0E-6;
        this.driving = false;
        this.connected = true;
        this.dataMapSize = 24;
        this.dtf = DateTimeFormat.forPattern((String)"E.h");
        this.name = name;
        this.id = IdGenerator.createId();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public CustomerInfo initialize(SocialGroup socialGroup, String gender, Map<Integer, Activity> activities, List<GroupActivity> groupActivities, CarType car, EvSocialClass esc, CustomerServiceAccessor service, Config config) {
        this.socialGroup = socialGroup;
        this.activities = activities;
        this.groupActivities = new ArrayList<GroupActivity>(groupActivities);
        this.groupActivities.sort((g1, g2) -> ((Activity)activities.get(g2.getActivityId())).getInterval() - ((Activity)activities.get(g1.getActivityId())).getInterval());
        this.gender = gender;
        this.car = car;
        this.service = service;
        this.config = config;
        this.generator = service.getRandomSeedRepo().getRandomSeed(this.name, 1L, "model");
        this.setCurrentCapacity(0.5 * car.getMaxCapacity());
        this.riskAttitude = RiskAttitude.values()[this.generator.nextInt(3)];
        this.customerInfo = new CustomerInfo(this.name, 1).withPowerType(PowerType.ELECTRIC_VEHICLE).withControllableKW(-car.getHomeChargeKW()).withUpRegulationKW(-car.getHomeChargeKW()).withDownRegulationKW(car.getHomeChargeKW()).withStorageCapacity(car.getMaxCapacity());
        this.configTariffEvaluator(esc);
        this.sleepActivity = new Activity("sleep");
        return this.customerInfo;
    }

    private void configTariffEvaluator(AbstractCustomer ac) {
        TariffEvaluationWrapper wrapper = this.createTariffEvaluationWrapper();
        this.evaluator = ac.createTariffEvaluator((CustomerModelAccessor)wrapper);
        this.evaluator.initializeInconvenienceFactors(this.config.getTouFactor(), this.config.getTieredRateFactor(), this.config.getVariablePricingFactor(), this.config.getInterruptibilityFactor());
        double weight = this.generator.nextDouble() * this.config.getWeightInconvenience();
        double expDuration = this.config.getMinDefaultDuration() + this.generator.nextInt(this.config.getMaxDefaultDuration() - this.config.getMinDefaultDuration());
        this.evaluator.withInconvenienceWeight(weight).withInertia(this.config.getNsInertia()).withPreferredContractDuration(expDuration).withRationality(this.config.getRationalityFactor()).withTariffEvalDepth(this.config.getTariffCount()).withTariffSwitchFactor(this.config.getBrokerSwitchFactor());
        this.evaluator.initializeRegulationFactors(this.car.getHomeChargeKW() * this.car.getCurtailmentFactor(), this.car.getHomeChargeKW() * this.car.getDischargeFactor(), this.car.getHomeChargeKW() * this.car.getDownRegFactor());
    }

    public void evaluateTariffs(List<Tariff> tariffs) {
        this.evaluator.evaluateTariffs();
    }

    public void step(Timeslot timeslot) {
        int day = timeslot.getStartTime().getDayOfWeek();
        int hour = timeslot.getStartTime().getHourOfDay();
        TariffSubscription sub = null;
        List subs = this.service.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(this.customerInfo);
        if (subs == null || subs.size() == 0) {
            log.error("No subscriptions found for " + this.name);
            return;
        }
        sub = (TariffSubscription)subs.get(0);
        this.driving = false;
        this.handleRegulation(day, hour, sub);
        this.makeDayPlanning(hour, day);
        this.doActivities(day, hour);
        double[] loads = this.getLoads(day, hour);
        this.consumePower(loads, sub);
        this.setRegulation(loads[2], loads[3], sub);
    }

    private void handleRegulation(int day, int hour, TariffSubscription sub) {
        if (sub == null) {
            return;
        }
        double actualRegulation = sub.getRegulation() * (double)this.customerInfo.getPopulation();
        if (Math.abs(actualRegulation) < this.capacityEpsilon) {
            return;
        }
        log.info("{} regulate: {}", (Object)this.name, (Object)actualRegulation);
        double startCapacity = this.currentCapacity;
        try {
            if (actualRegulation > this.capacityEpsilon) {
                this.discharge(actualRegulation);
            } else if (actualRegulation < -this.capacityEpsilon) {
                this.charge(-1.0 * actualRegulation);
            }
        }
        catch (ChargeException ce) {
            log.error(String.valueOf(this.name) + " : " + ce);
        }
        if (Math.abs(startCapacity - this.currentCapacity) > this.capacityEpsilon) {
            log.info(String.format("%s regulated from %.1f to %.1f", this.name, startCapacity, this.currentCapacity));
        }
    }

    private void setRegulation(double up, double down, TariffSubscription sub) {
        if (sub == null) {
            return;
        }
        sub.setRegulationCapacity(new RegulationCapacity(sub, up, down));
        log.info(String.valueOf(this.name) + " setting regulation, up: " + up + "; down: " + down);
    }

    void makeDayPlanning(int hour, int day) {
        int i;
        if (hour != 0) {
            return;
        }
        if (this.todayMap == null) {
            this.tomorrowMap = new TimeslotData[24];
            i = 0;
            while (i < 24) {
                this.tomorrowMap[i] = new TimeslotData();
                ++i;
            }
            this.planTomorrow(day);
        }
        this.todayMap = this.tomorrowMap;
        this.tomorrowMap = new TimeslotData[24];
        i = 0;
        while (i < 24) {
            this.tomorrowMap[i] = new TimeslotData();
            ++i;
        }
        int tomorrow = (day - 1) % 7 + 1;
        this.planTomorrow(tomorrow);
        this.updateChargingHours();
    }

    private void planTomorrow(int nextDay) {
        int sleepSlot;
        int wakeupSlot = this.earlyWake + this.generator.nextInt(this.wakeRange);
        int i = 0;
        while (i < wakeupSlot) {
            this.tomorrowMap[i].setActivity(this.sleepActivity);
            ++i;
        }
        int i2 = sleepSlot = this.earlySleep + this.generator.nextInt(this.sleepRange);
        while (i2 < 24) {
            this.tomorrowMap[i2].setActivity(this.sleepActivity);
            ++i2;
        }
        block2: for (GroupActivity groupActivity : this.groupActivities) {
            Activity act = this.activities.get(groupActivity.getActivityId());
            if (nextDay < 6 && act.getName().equals("commuting")) {
                log.debug("commuting");
            }
            double p1 = this.generator.nextDouble();
            double p2 = this.generator.nextDouble();
            double p3 = this.generator.nextDouble();
            if (!(groupActivity.getProbability(this.gender) >= p1) || !(act.getDayProbability(nextDay) >= p2)) continue;
            double[] probabilities = new double[this.tomorrowMap.length];
            Arrays.fill(probabilities, 1.0);
            int open = 0;
            int i3 = 0;
            while (i3 < this.tomorrowMap.length) {
                if (this.tomorrowMap[i3].getActivity().isPresent()) {
                    probabilities[i3] = 0.0;
                } else {
                    ++open;
                }
                ++i3;
            }
            if (open == 0) continue;
            if (act.getInterval() > 0) {
                i3 = 0;
                while (i3 < this.tomorrowMap.length) {
                    if (i3 + act.getInterval() >= this.tomorrowMap.length) {
                        probabilities[i3] = 0.0;
                    } else if (0.0 != probabilities[i3]) {
                        int j = i3 + 1;
                        while (j < i3 + act.getInterval() + 1) {
                            if (0.0 == probabilities[j]) {
                                probabilities[i3] = 0.0;
                                break;
                            }
                            ++j;
                        }
                        if (1.0 == probabilities[i3]) {
                            probabilities[i3] = act.getProbabilityForTimeslot(i3);
                        }
                    }
                    ++i3;
                }
            }
            double psum = 0.0;
            int ts = 0;
            while (ts < this.tomorrowMap.length) {
                if (probabilities[ts] > 0.0) {
                    probabilities[ts] = act.getProbabilityForTimeslot(ts);
                    psum += probabilities[ts];
                }
                ++ts;
            }
            if (!(psum > this.epsilon)) continue;
            ts = 0;
            while (ts < this.tomorrowMap.length) {
                int n = ts++;
                probabilities[n] = probabilities[n] / psum;
            }
            ts = 0;
            while (ts < this.tomorrowMap.length) {
                if ((p3 -= probabilities[ts]) <= this.epsilon) {
                    this.tomorrowMap[ts].setActivity(act);
                    this.tomorrowMap[ts].setGroupActivity(groupActivity);
                    if (act.getInterval() <= 0) continue block2;
                    this.tomorrowMap[ts + act.getInterval()].setActivity(act);
                    this.tomorrowMap[ts + act.getInterval()].setGroupActivity(groupActivity);
                    continue block2;
                }
                ++ts;
            }
        }
        i = 0;
        while (i < this.tomorrowMap.length) {
            double intendedDistance = 0.0;
            if (this.tomorrowMap[i].getGroupActivity().isPresent()) {
                intendedDistance = this.tomorrowMap[i].getGroupActivity().get().getDailyKm(this.getGender());
            }
            this.tomorrowMap[i].setIntendedDistance(intendedDistance);
            ++i;
        }
    }

    private void updateChargingHours() {
        double currentCapacity = 0.0;
        Stack<Activity> activityStack = new Stack<Activity>();
        TimeslotData[] timeslotDataArray = this.todayMap;
        int n = this.todayMap.length;
        int n2 = 0;
        while (n2 < n) {
            TimeslotData entry = timeslotDataArray[n2];
            entry.setChargingCapacity(this.car.getHomeChargeKW());
            ++n2;
        }
        int i = 0;
        while (i < this.todayMap.length) {
            Activity current;
            if (this.todayMap[i].getActivity().isPresent() && (current = this.todayMap[i].getActivity().get()).getInterval() > 0) {
                if (!activityStack.isEmpty() && ((Activity)activityStack.peek()).equals(current)) {
                    activityStack.pop();
                } else {
                    activityStack.push(current);
                    double sample = this.generator.nextDouble();
                    currentCapacity = this.todayMap[i].getActivity().get().getChargerProbability() >= sample ? this.car.getAwayChargeKW() : 0.0;
                    int j = i + 1;
                    while (j < this.todayMap.length) {
                        if (this.todayMap[j].getActivity().isPresent() && this.todayMap[j].getActivity().get() == current) break;
                        this.todayMap[j].setChargingCapacity(currentCapacity);
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (!activityStack.isEmpty()) {
            log.error("Activity stack should be empty: car {}, activity {}", (Object)this.car.getName(), (Object)((Activity)activityStack.peek()).getName());
        }
        int chargingHours = 0;
        int i2 = this.todayMap.length - 1;
        while (i2 >= 0) {
            TimeslotData data = this.todayMap[i2];
            if (data.getIntendedDistance() > this.epsilon) {
                chargingHours = 0;
            } else {
                data.setHoursTillNextDrive(++chargingHours);
            }
            --i2;
        }
    }

    public void doActivities(int day, int hour) {
        TimeslotData timeslotData = this.todayMap[hour];
        double intendedDistance = timeslotData.getIntendedDistance();
        double neededCapacity = this.getNeededCapacity(intendedDistance);
        if (intendedDistance < this.distanceEpsilon) {
            return;
        }
        if (neededCapacity > this.currentCapacity) {
            log.warn("Customer {} out of juice!", (Object)this.getName());
            return;
        }
        try {
            double before = this.currentCapacity;
            this.discharge(neededCapacity);
            log.info("{} {} at {}, {} kms {} kWh from {} to {}", (Object)this.name, (Object)timeslotData.getActivity().get().getName(), (Object)this.dtf.print((ReadableInstant)this.service.getTimeService().getCurrentDateTime()), (Object)intendedDistance, (Object)neededCapacity, (Object)before, (Object)this.currentCapacity);
            this.driving = true;
        }
        catch (ChargeException ce) {
            log.error((Object)ce);
        }
    }

    private void consumePower(double[] loads, TariffSubscription sub) {
        sub.usePower(loads[0] + loads[1]);
        try {
            this.charge(loads[0] + loads[1]);
        }
        catch (ChargeException ce) {
            log.error(ce.getMessage());
        }
    }

    public double getDominantLoad() {
        double dailyKm = 0.0;
        for (GroupActivity entry : this.groupActivities) {
            dailyKm += entry.getDailyKm(this.gender);
        }
        return this.getNeededCapacity(dailyKm);
    }

    public double[] getLoads(int day, int hour) {
        double[] loads = new double[4];
        if (this.driving) {
            return loads;
        }
        double currentCapacity = this.getCurrentCapacity();
        double minCapacity = this.getLongTermNeeded(hour + 1);
        int hoursOfCharge = this.todayMap[hour].getHoursTillNextDrive();
        double nomCapacity = Math.max(this.getShortTermNeeded(hour + hoursOfCharge), this.car.getMaxCapacity() * this.riskAttitude.preferredMinimumCapacity);
        loads[0] = Math.max(0.0, minCapacity - currentCapacity);
        loads[0] = Math.min(loads[0], this.todayMap[hour].getChargingCapacity());
        loads[1] = Math.max(0.0, nomCapacity - currentCapacity - loads[0]);
        loads[1] = Math.min(loads[1], this.todayMap[hour].getChargingCapacity());
        loads[2] = Math.max(0.0, currentCapacity - minCapacity);
        loads[2] = Math.min(loads[2], this.getDischargingCapacity());
        if (loads[2] < this.capacityEpsilon) {
            loads[2] = 0.0;
        }
        loads[3] = -1.0 * (this.todayMap[hour].getChargingCapacity() - (loads[0] + loads[1]));
        loads[3] = Math.max(loads[3], this.getCurrentCapacity() - this.car.getMaxCapacity());
        if (loads[3] > -this.capacityEpsilon) {
            loads[3] = 0.0;
        }
        this.todayMap[hour].setUpRegulationCharge(loads[1]);
        this.todayMap[hour].setUpRegulation(loads[2]);
        this.todayMap[hour].setDownRegulation(loads[3]);
        return loads;
    }

    private double getShortTermNeeded(int pointer) {
        double neededCapacity = 0.0;
        while (pointer < 24) {
            double tsDistance;
            if ((tsDistance = this.todayMap[pointer++].getIntendedDistance()) < this.distanceEpsilon) break;
            neededCapacity += this.getNeededCapacity(tsDistance);
        }
        return neededCapacity * this.riskAttitude.distanceFactor;
    }

    private double getLongTermNeeded(int hour) {
        double neededCapacity = 0.0;
        int pointer = 24;
        while (--pointer >= hour) {
            double tsDistance = this.todayMap[pointer].getIntendedDistance();
            if (tsDistance < this.distanceEpsilon) {
                neededCapacity -= Math.min(neededCapacity, this.car.getHomeChargeKW());
                continue;
            }
            neededCapacity += this.getNeededCapacity(tsDistance);
            neededCapacity = Math.min(neededCapacity, this.car.getMaxCapacity());
        }
        return neededCapacity;
    }

    public double getCurrentCapacity() {
        return this.currentCapacity;
    }

    @StateChange
    public void setCurrentCapacity(double currentCapacity) {
        double d = currentCapacity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        this.currentCapacity = currentCapacity;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public void discharge(double kwh) throws ChargeException {
        if (!(this.currentCapacity >= kwh - this.capacityEpsilon)) {
            throw new ChargeException("Not possible to discharge " + this.name + " : " + kwh + " from " + this.currentCapacity);
        }
        this.setCurrentCapacity(this.currentCapacity - kwh);
    }

    public void charge(double kwh) throws ChargeException {
        if (this.currentCapacity + kwh <= this.car.getMaxCapacity()) {
            double startCapacity = this.currentCapacity;
            this.setCurrentCapacity(this.currentCapacity + kwh);
            if (Math.abs(startCapacity - this.currentCapacity) > this.capacityEpsilon) {
                log.info(String.format("%s charging from %.1f to %.1f", this.name, startCapacity, this.currentCapacity));
            }
        } else {
            throw new ChargeException("Not possible to charge " + this.name + " : " + kwh + " at " + this.currentCapacity + " (maxCap " + this.car.getMaxCapacity() + ")");
        }
    }

    public double getNeededCapacity(double distance) {
        double fuelEconomy = this.car.getRange() / this.car.getMaxCapacity();
        return distance / fuelEconomy;
    }

    public double getDischargingCapacity() {
        return Math.min(this.car.getHomeChargeKW(), this.currentCapacity);
    }

    CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    CarType getCar() {
        return this.car;
    }

    SocialGroup getSocialGroup() {
        return this.socialGroup;
    }

    Map<Integer, Activity> getActivities() {
        return this.activities;
    }

    List<GroupActivity> getGroupActivities() {
        return this.groupActivities;
    }

    String getGender() {
        return this.gender;
    }

    String getRiskAttitude() {
        return this.riskAttitude.toString();
    }

    void setRiskAttitude(int riskNr) {
        try {
            this.riskAttitude = RiskAttitude.values()[riskNr];
        }
        catch (Exception exception) {}
    }

    TariffEvaluationWrapper createTariffEvaluationWrapper() {
        return new TariffEvaluationWrapper();
    }

    void setGenerator(RandomSeed generator) {
        this.generator = generator;
    }

    void setDriving(boolean driving) {
        this.driving = driving;
    }

    boolean isDriving() {
        return this.driving;
    }

    TimeslotData[] getTodayMap() {
        return this.todayMap;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EvCustomer.java", EvCustomer.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.evcustomer.customers.EvCustomer", "java.lang.String", "name", ""), 135);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCurrentCapacity", "org.powertac.evcustomer.customers.EvCustomer", "double", "currentCapacity", "", "void"), 687);
    }

    public class ChargeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ChargeException(String message) {
            super(message);
        }
    }

    public static enum RiskAttitude {
        averse(0.4, 0.8),
        neutral(0.2, 0.6),
        eager(0.1, 0.4);

        private double distanceFactor;
        private double preferredMinimumCapacity;

        private RiskAttitude(double distanceFactor, double preferredMinimumCapacity) {
            this.distanceFactor = distanceFactor;
            this.preferredMinimumCapacity = preferredMinimumCapacity;
        }
    }

    class TariffEvaluationWrapper
    implements CustomerModelAccessor {
        private static final int hrsPerDay = 24;

        public CustomerInfo getCustomerInfo() {
            return EvCustomer.this.customerInfo;
        }

        public CapacityProfile getCapacityProfile(Tariff tariff) {
            double[] result = new double[EvCustomer.this.config.getProfileLength()];
            int i = 0;
            while (i < result.length) {
                result[i] = EvCustomer.this.getDominantLoad() / 24.0;
                ++i;
            }
            Instant start = EvCustomer.this.service.getTimeslotRepo().currentTimeslot().getStartInstant();
            return new CapacityProfile(result, start.toDateTime(DateTimeZone.UTC).withHourOfDay(0).toInstant().plus(86400000L));
        }

        public double getBrokerSwitchFactor(boolean isSuperseding) {
            double result = EvCustomer.this.config.getBrokerSwitchFactor();
            if (isSuperseding) {
                return result * 5.0;
            }
            return result;
        }

        public double getTariffChoiceSample() {
            return EvCustomer.this.generator.nextDouble();
        }

        public double getInertiaSample() {
            return EvCustomer.this.generator.nextDouble();
        }

        public double getShiftingInconvenienceFactor(Tariff tariff) {
            return 0.0;
        }

        public void notifyCustomer(TariffSubscription oldsub, TariffSubscription newsub, int population) {
        }
    }

    class TimeslotData {
        private GroupActivity groupActivity;
        private Activity activity;
        private Activity previousActivity;
        private double chargingCapacity = 0.0;
        private double intendedDistance = 0.0;
        private double upRegulation = 0.0;
        private double upRegulationCharge = 0.0;
        private double downRegulation = 0.0;
        private int hoursTillNextDrive = 0;

        TimeslotData() {
        }

        Optional<GroupActivity> getGroupActivity() {
            return Optional.ofNullable(this.groupActivity);
        }

        void setGroupActivity(GroupActivity ga) {
            this.groupActivity = ga;
        }

        Optional<Activity> getActivity() {
            return Optional.ofNullable(this.activity);
        }

        void setActivity(Activity act) {
            this.activity = act;
        }

        Optional<Activity> getPreviousActivity() {
            return Optional.ofNullable(this.previousActivity);
        }

        void setPreviousActivity(Activity act) {
            this.previousActivity = act;
        }

        double getChargingCapacity() {
            return this.chargingCapacity;
        }

        void setChargingCapacity(double capacity) {
            this.chargingCapacity = capacity;
        }

        double getIntendedDistance() {
            return this.intendedDistance;
        }

        void setIntendedDistance(double intendedDistance) {
            this.intendedDistance = intendedDistance;
        }

        double getUpRegulation() {
            return this.upRegulation;
        }

        void setUpRegulation(double upRegulation) {
            this.upRegulation = upRegulation;
        }

        double getUpRegulationCharge() {
            return this.upRegulationCharge;
        }

        void setUpRegulationCharge(double upRegulationCharge) {
            this.upRegulationCharge = upRegulationCharge;
        }

        double getDownRegulation() {
            return this.downRegulation;
        }

        void setDownRegulation(double downRegulation) {
            this.downRegulation = downRegulation;
        }

        int getHoursTillNextDrive() {
            return this.hoursTillNextDrive;
        }

        void setHoursTillNextDrive(int hoursTillNextDrive) {
            this.hoursTillNextDrive = hoursTillNextDrive;
        }
    }
}

