/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.evcustomer.beans;

import org.powertac.common.config.ConfigurableValue;

public class GroupActivity {
    private String name;
    @ConfigurableValue(valueType="Integer", dump=false, description="Foreign key: id of associated SocialGroup")
    private int groupId;
    @ConfigurableValue(valueType="Integer", dump=false, description="Foreign key: id of associated Activity")
    private int activityId;
    @ConfigurableValue(valueType="Double", dump=false, description="Daily km for males in this group/activity")
    private double maleDailyKm;
    @ConfigurableValue(valueType="Double", dump=false, description="Daily km for females in this group/activity")
    private double femaleDailyKm;
    @ConfigurableValue(valueType="Double", dump=false, description="Probability for males in this group/activity")
    private double maleProbability;
    @ConfigurableValue(valueType="Double", dump=false, description="Probability for females in this group/activity")
    private double femaleProbability;

    public GroupActivity(String name) {
        this.name = name;
    }

    public void initialize(int activityId, double maleDailyKm, double femaleDailyKm, double maleProbability, double femaleProbability) {
        this.activityId = activityId;
        this.maleDailyKm = maleDailyKm;
        this.femaleDailyKm = femaleDailyKm;
        this.maleProbability = maleProbability;
        this.femaleProbability = femaleProbability;
    }

    public String getName() {
        return this.name;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getActivityId() {
        return this.activityId;
    }

    public double getDailyKm(String gender) {
        if (gender.equals("male")) {
            return this.maleDailyKm;
        }
        return this.femaleDailyKm;
    }

    public double getProbability(String gender) {
        if (gender.equals("male")) {
            return this.maleProbability;
        }
        return this.femaleProbability;
    }

    public double getMaleDailyKm() {
        return this.maleDailyKm;
    }

    public double getFemaleDailyKm() {
        return this.femaleDailyKm;
    }

    public double getMaleProbability() {
        return this.maleProbability;
    }

    public double getFemaleProbability() {
        return this.femaleProbability;
    }
}

