/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.evcustomer.beans;

import org.powertac.common.IdGenerator;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;

@ConfigurableInstance
public class CarType {
    private long id;
    private double maxCapacity;
    private double range;
    private double homeChargeKW;
    private double awayChargeKW;
    private double curtailmentFactor = -0.08;
    private double dischargeFactor = -0.05;
    private double downRegFactor = 0.1;
    private String name;

    public CarType(String name) {
        this.name = name;
        this.id = IdGenerator.createId();
    }

    public void configure(String name, double maxCapacity, double range, double homeChargeKW, double awayChargeKW) {
        this.name = name;
        this.setMaxCapacity(maxCapacity);
        this.setRange(range);
        this.setHomeChargeKW(homeChargeKW);
        this.setAwayChargeKW(awayChargeKW);
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public double getMaxCapacity() {
        return this.maxCapacity;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="Maximum battery capacity")
    public void setMaxCapacity(double capacity) {
        this.maxCapacity = capacity;
    }

    public double getRange() {
        return this.range;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="Maximum range in km")
    public void setRange(double range) {
        this.range = range;
    }

    public double getHomeChargeKW() {
        return this.homeChargeKW;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="Maximum charge rate in kw, home station")
    public void setHomeChargeKW(double kw) {
        this.homeChargeKW = kw;
    }

    public double getAwayChargeKW() {
        return this.awayChargeKW;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="Maximum charge rate in kw, remote station")
    public void setAwayChargeKW(double kw) {
        this.awayChargeKW = kw;
    }

    public double getCurtailmentFactor() {
        return this.curtailmentFactor;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="Expected curtailment per timeslot, as a ratio of homeChargeKW")
    public void setCurtailmentFactor(double ratio) {
        this.curtailmentFactor = ratio;
    }

    public double getDischargeFactor() {
        return this.dischargeFactor;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="Expected V2G per timeslot as a fn of homeChargeKW")
    public void setDischargeFactor(double ratio) {
        this.dischargeFactor = ratio;
    }

    public double getDownRegFactor() {
        return this.downRegFactor;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="expected down regulation per timeslot as fn of homeChargeKW")
    public void setDownRegFactor(double ratio) {
        this.downRegFactor = ratio;
    }
}

