/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.evcustomer.beans;

import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;

public class Activity {
    private static Logger log = LogManager.getLogger((String)Activity.class.getName());
    private String name;
    @ConfigurableValue(valueType="Integer", dump=false, description="Group ID")
    private int id;
    @ConfigurableValue(valueType="Double", dump=false, description="Weekday value")
    private double weekdayWeight = 1.0;
    @ConfigurableValue(valueType="Double", dump=false, description="Weekend value")
    private double weekendWeight = 1.0;
    private double[] weeklyProfile;
    private List<String> weeklyProfileRaw;
    private double[] dailyProfile;
    private List<String> dailyProfileRaw;
    @ConfigurableValue(valueType="Integer", dump=false, description="Interval in hours between daily trip pair")
    private int interval = 0;
    @ConfigurableValue(valueType="Double", dump=false, description="Probability of charger at destination")
    private double chargerProbability = 0.0;

    public Activity() {
    }

    public Activity(String name) {
        this.name = name;
    }

    public double getDayWeight(int day) {
        if (day < 6) {
            return this.weekdayWeight;
        }
        return this.weekendWeight;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getChargerProbability() {
        return this.chargerProbability;
    }

    public void setChargerProbability(double prob) {
        this.chargerProbability = prob;
    }

    public int getInterval() {
        return this.interval;
    }

    public double getWeekdayWeight() {
        return this.weekdayWeight;
    }

    public double getWeekendWeight() {
        return this.weekendWeight;
    }

    @ConfigurableValue(valueType="List", dump=false, description="When this activity might start")
    public void setWeeklyProfile(List<String> value) {
        int daysPerWeek = 7;
        this.weeklyProfile = new double[daysPerWeek];
        if (value.size() != daysPerWeek) {
            log.warn("incorrect week token count {} activity {}", (Object)value.size(), (Object)this.getName());
        }
        int index = 0;
        for (String token : value) {
            this.weeklyProfile[index++] = Double.parseDouble(token);
            if (index >= this.weeklyProfile.length) break;
        }
    }

    public List<String> getWeeklyProfile() {
        return this.weeklyProfileRaw;
    }

    public Optional<double[]> getWeeklyProfileOptional() {
        return Optional.ofNullable(this.weeklyProfile);
    }

    @ConfigurableValue(valueType="List", dump=false, description="When this activity might start")
    public void setDailyProfile(List<String> value) {
        this.dailyProfileRaw = value;
        int slotsPerDay = 24;
        this.dailyProfile = new double[slotsPerDay];
        if (value.size() != slotsPerDay) {
            log.warn("incorrect day token count {} activity {}", (Object)value.size(), (Object)this.getName());
        }
        int index = 0;
        for (String token : value) {
            this.dailyProfile[index++] = Double.parseDouble(token);
            if (index >= this.dailyProfile.length) break;
        }
        double psum = 0.0;
        double[] dArray = this.dailyProfile;
        int n = this.dailyProfile.length;
        int n2 = 0;
        while (n2 < n) {
            double prob = dArray[n2];
            psum += prob;
            ++n2;
        }
        int h = 0;
        while (h < this.dailyProfile.length) {
            int n3 = h++;
            this.dailyProfile[n3] = this.dailyProfile[n3] / psum;
        }
    }

    public List<String> getDailyProfile() {
        return this.dailyProfileRaw;
    }

    public Optional<double[]> getDailyProfileOptional() {
        return Optional.ofNullable(this.dailyProfile);
    }

    public double getDayProbability(int dayOfWeek) {
        double result = 1.0;
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            log.error("bad day-of-week {} in probabilityForTimeslot", (Object)dayOfWeek);
        } else {
            result = !this.getWeeklyProfileOptional().isPresent() ? (result *= this.getDayWeight(dayOfWeek)) : (result *= this.weeklyProfile[dayOfWeek - 1]);
        }
        return result;
    }

    public double getProbabilityForTimeslot(int slot) {
        double result = 1.0;
        if (slot < 0 || slot > 23) {
            log.error("bad slot {} in probabilityForTimeslot", (Object)slot);
            result = 0.0;
        } else {
            result = this.getDailyProfileOptional().isPresent() ? this.getDailyProfileOptional().get()[slot] : 1.0;
        }
        return result;
    }

    public void setInterval(int value) {
        this.interval = value;
    }

    public void setId(int value) {
        this.id = value;
    }
}

