/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.evcustomer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.spring.SpringApplicationContext;

public final class Config {
    private static Logger log = LogManager.getLogger((String)Config.class.getName());
    private static Config instance = null;
    private ServerConfiguration serverConfiguration;
    private double epsilon = 2.7;
    private double lambda = 20.0;
    @ConfigurableValue(valueType="Double", dump=false, description="Aversion to TOU tariff")
    private double touFactor = 0.05;
    @ConfigurableValue(valueType="Double", dump=false, description="Aversion to tariffs involving curtailment")
    private double interruptibilityFactor = 0.1;
    @ConfigurableValue(valueType="Double", dump=false, description="Aversion to variable-price tariffs")
    private double variablePricingFactor = 0.1;
    @ConfigurableValue(valueType="Double", dump=false, description="Aversion to tiered rates")
    private double tieredRateFactor = 0.1;
    @ConfigurableValue(valueType="Integer", dump=false, description="Minimum expected duration of subscription in days")
    private int minDefaultDuration = 7;
    @ConfigurableValue(valueType="Integer", dump=false, description="Maximum expected duration of subscription in days")
    private int maxDefaultDuration = 21;
    @ConfigurableValue(valueType="Double", dump=false, description="Rationality of these customers")
    private double rationalityFactor = 0.9;
    @ConfigurableValue(valueType="Integer", dump=false, description="Number of tariffs/broker to consider")
    private int tariffCount = 5;
    @ConfigurableValue(valueType="Double", dump=false, description="Aversion to switching brokers")
    private double brokerSwitchFactor = 0.02;
    @ConfigurableValue(valueType="Double", dump=false, description="Importance of inconvenience factors")
    private double weightInconvenience = 0.2;
    @ConfigurableValue(valueType="Double", dump=false, description="Tariff evaluation inertia")
    private double nsInertia = 0.8;
    @ConfigurableValue(valueType="Integer", dump=false, description="Length in timeslots of evaluation profile")
    private int profileLength = 48;
    @ConfigurableValue(valueType="List", dump=false, description="classnames of bean types to be configured")
    private List<String> beanTypes;
    private Map<String, Collection<?>> beans;

    private Config() {
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getTouFactor() {
        return this.touFactor;
    }

    public double getInterruptibilityFactor() {
        return this.interruptibilityFactor;
    }

    public double getVariablePricingFactor() {
        return this.variablePricingFactor;
    }

    public double getTieredRateFactor() {
        return this.tieredRateFactor;
    }

    public int getMinDefaultDuration() {
        return this.minDefaultDuration;
    }

    public int getMaxDefaultDuration() {
        return this.maxDefaultDuration;
    }

    public double getRationalityFactor() {
        return this.rationalityFactor;
    }

    public double getNsInertia() {
        return this.nsInertia;
    }

    public double getBrokerSwitchFactor() {
        return this.brokerSwitchFactor;
    }

    public double getWeightInconvenience() {
        return this.weightInconvenience;
    }

    public int getTariffCount() {
        return this.tariffCount;
    }

    public int getProfileLength() {
        return this.profileLength;
    }

    @Deprecated
    public void configure() {
        if (this.serverConfiguration == null) {
            this.serverConfiguration = (ServerConfiguration)SpringApplicationContext.getBean((String)"serverPropertiesService");
        }
        if (this.serverConfiguration == null) {
            log.warn("Cannot find serverPropertiesService");
        } else {
            this.serverConfiguration.configureMe((Object)this);
        }
    }

    public void configure(ServerConfiguration configSource) {
        this.serverConfiguration = configSource;
        configSource.configureMe((Object)this);
    }

    public Map<String, Collection<?>> getBeans() {
        if (this.beans != null) {
            return this.beans;
        }
        this.configure();
        this.beans = new HashMap();
        for (String classname : this.beanTypes) {
            try {
                Class<?> clazz = Class.forName("org.powertac.evcustomer.beans." + classname);
                Collection list = this.serverConfiguration.configureInstances(clazz);
                this.beans.put(classname, list);
                log.info("Loaded " + list.size() + " instances of " + classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("Cannot find class " + classname);
            }
        }
        return this.beans;
    }

    public static synchronized Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static synchronized void recycle() {
        instance = null;
    }
}

