/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String original;
    @Nullable
    private transient List<Comparable<?>> list;

    public Version(@Nonnull String version) {
        this.original = version;
    }

    @Nonnull
    public List<Comparable<?>> getParts() {
        if (this.list == null) {
            this.list = Version.parse(this.original);
        }
        return this.list;
    }

    @Override
    public int compareTo(@Nonnull Version o) {
        if (this.original.equalsIgnoreCase(o.original)) {
            return 0;
        }
        List<Comparable<?>> partsB = o.getParts();
        List<Comparable<?>> partsA = this.getParts();
        int sizeA = partsA.size();
        int sizeB = partsB.size();
        for (int i = 0; i < Math.max(sizeA, sizeB); ++i) {
            Integer b;
            Integer a = i < sizeA ? partsA.get(i) : Integer.valueOf(0);
            Comparable<Integer> comparable = b = i < sizeB ? partsB.get(i) : Integer.valueOf(0);
            if (!a.getClass().equals(b.getClass())) {
                return Integer.class.equals(a.getClass()) ? 1 : -1;
            }
            int cmp = a.compareTo(b);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public String toString() {
        return this.original;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version other = (Version)o;
        if (this.original.equalsIgnoreCase(other.original)) {
            return true;
        }
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.getParts().hashCode();
    }

    @Nonnull
    private static List<Comparable<?>> parse(@Nonnull String version) {
        ArrayList parts = new ArrayList(5);
        int len = version.length();
        StringBuilder pending = new StringBuilder(len);
        int previous = 0;
        block4: for (int i = 0; i < len; ++i) {
            char c = version.charAt(i);
            int type = c >= '0' && c <= '9' ? 1 : (Character.isDigit(c) ? 2 : (Character.isLetter(c) || Character.isIdeographic(c) ? 3 : 0));
            if (type != previous) {
                Version.addPendingPart(parts, pending, (byte)previous);
                previous = type;
            }
            switch (type) {
                case 1: {
                    pending.append(c);
                    continue block4;
                }
                case 2: 
                case 3: {
                    pending.append(Character.toLowerCase(c));
                    continue block4;
                }
            }
        }
        Version.addPendingPart(parts, pending, (byte)previous);
        parts.trimToSize();
        return Collections.unmodifiableList(parts);
    }

    private static void addPendingPart(@Nonnull List<Comparable<?>> parts, @Nonnull StringBuilder pending, byte type) {
        switch (type) {
            case 1: {
                parts.add(Integer.valueOf(Integer.parseInt(pending.toString())));
                pending.setLength(0);
                break;
            }
            case 2: 
            case 3: {
                parts.add((Comparable<?>)((Object)pending.toString()));
                pending.setLength(0);
                break;
            }
        }
    }
}

