/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.version;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.powernukkit.version.Version;
import org.powernukkit.version.VersionStringComparator;

public class ConcurrentCachedVersionStringComparator
extends VersionStringComparator {
    private final ConcurrentHashMap<String, WeakReference<Version>> cache = new ConcurrentHashMap();
    private final AtomicInteger comparisons = new AtomicInteger();
    private final int gcFrequency;

    public ConcurrentCachedVersionStringComparator(int gcFrequency) {
        this.gcFrequency = gcFrequency;
    }

    @Override
    public int compare(@Nonnull String o1, @Nonnull String o2) {
        if (this.gcFrequency >= 0 && this.comparisons.getAndIncrement() == this.gcFrequency) {
            this.removeGarbageCollected();
        }
        return this.getVersion(o1).compareTo(this.getVersion(o2));
    }

    public void removeGarbageCollected() {
        this.cache.values().removeIf(ref -> ref.get() == null);
        this.comparisons.set(0);
    }

    @Nonnull
    private Version getVersion(@Nonnull String versionString) {
        Version version = null;
        WeakReference<Version> reference = this.cache.get(versionString);
        if (reference != null) {
            version = (Version)reference.get();
        }
        if (version == null) {
            version = new Version(versionString);
            this.cache.put(versionString, new WeakReference<Version>(version));
        }
        return version;
    }

    public void clearCache() {
        this.cache.clear();
    }
}

