/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.version;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.powernukkit.version.Version;
import org.powernukkit.version.VersionStringComparator;

public class CachedVersionStringComparator
extends VersionStringComparator {
    private final Map<String, Version> cache;

    public CachedVersionStringComparator(final int cacheSize) {
        this.cache = new LinkedHashMap<String, Version>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Version> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    @Override
    public int compare(@Nonnull String o1, @Nonnull String o2) {
        return this.cache.computeIfAbsent(o1, Version::new).compareTo(this.cache.computeIfAbsent(o2, Version::new));
    }

    public void clearCache() {
        this.cache.clear();
    }
}

