/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.mocks;

import cn.nukkit.Server;
import cn.nukkit.command.ConsoleCommandSender;
import cn.nukkit.command.SimpleCommandMap;
import cn.nukkit.console.NukkitConsole;
import cn.nukkit.event.server.QueryRegenerateEvent;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.lang.BaseLang;
import cn.nukkit.level.Level;
import cn.nukkit.metadata.EntityMetadataStore;
import cn.nukkit.metadata.LevelMetadataStore;
import cn.nukkit.metadata.PlayerMetadataStore;
import cn.nukkit.network.Network;
import cn.nukkit.network.query.QueryHandler;
import cn.nukkit.network.rcon.RCON;
import cn.nukkit.permission.BanList;
import cn.nukkit.plugin.PluginManager;
import cn.nukkit.plugin.service.NKServiceManager;
import cn.nukkit.resourcepacks.ResourcePackManager;
import cn.nukkit.scheduler.ServerScheduler;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.PlayerDataSerializer;
import cn.nukkit.utils.Watchdog;
import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.util.FileUtils;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.configuration.injection.scanner.MockScanner;
import org.mockito.internal.util.collections.Sets;
import org.mockito.stubbing.Answer;
import org.powernukkit.tests.api.MockServer;
import org.powernukkit.tests.api.ReflectionUtil;
import org.powernukkit.tests.junit.jupiter.PowerNukkitExtension;
import org.powernukkit.tests.mocks.MockUtil;
import org.powernukkit.tests.mocks.Mocker;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class ServerMocker
extends Mocker<Server> {
    private static final Class<?> classPositionTrackingService;
    private static final Method getPositionTrackingService;
    private static final Field positionTrackingServiceField;
    private MockServer config;
    @Mock
    PluginManager pluginManager;
    @Mock
    PlayerDataSerializer playerDataSerializer;
    @Mock
    DB nameLookup;
    @Mock
    Watchdog watchdog;
    @Mock
    NukkitConsole console;
    @Mock
    QueryRegenerateEvent queryRegenerateEvent;
    @Mock
    Network network;
    @Mock
    RCON rcon;
    @Mock
    EntityMetadataStore entityMetadata;
    @Mock
    PlayerMetadataStore playerMetadata;
    @Mock
    LevelMetadataStore levelMetadata;
    @Mock
    QueryHandler queryHandler;
    @Mock
    ServerScheduler serverScheduler;
    Object posTrackingService;
    File tempDir;
    File worldsDir;
    File playersDir;
    File pluginsDir;
    File resourcePacksDir;
    File bannedPlayersFile;
    File bannedIpsFile;
    File posTrackingServiceDir;
    Server server;
    BaseLang baseLang = new BaseLang("eng");

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static void setServerInstance(@Nullable Server server) {
        ReflectionUtil.execute(() -> ReflectionUtil.setField(null, Server.class.getDeclaredField("instance"), (Object)server));
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public ServerMocker() {
        this(PowerNukkitExtension.class.getAnnotation(MockServer.class));
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public ServerMocker(MockServer config) {
        this.config = config;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public void setActive() {
        ServerMocker.setServerInstance(this.server);
    }

    @Override
    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public Server create() {
        MockitoAnnotations.initMocks((Object)this);
        Server server = this.server = this.config.callsRealMethods() ? (Server)Mockito.mock(Server.class, (Answer)Mockito.CALLS_REAL_METHODS) : (Server)Mockito.mock(Server.class);
        if (this.config.initPrivateFields() || this.config.createTempDir()) {
            this.tempDir = this.config.createTempDir() ? Files.createTempDir() : new File(".");
            this.worldsDir = new File(this.tempDir, "worlds");
            this.playersDir = new File(this.tempDir, "players");
            this.pluginsDir = new File(this.tempDir, "plugins");
            this.resourcePacksDir = new File(this.tempDir, "resource_packs");
            this.bannedPlayersFile = new File(this.tempDir, "banned-players.json");
            this.bannedIpsFile = new File(this.tempDir, "banned-ips.json");
            if (positionTrackingServiceField != null) {
                this.posTrackingServiceDir = new File(this.tempDir, "services/position_tracking_db");
            }
        }
        if (positionTrackingServiceField != null) {
            boolean delete = false;
            if (this.posTrackingServiceDir == null) {
                this.posTrackingServiceDir = Files.createTempDir();
                delete = true;
            }
            MockSettings mockSettings = Mockito.withSettings().useConstructor(new Object[]{this.posTrackingServiceDir});
            if (this.config.callsRealMethods()) {
                mockSettings = mockSettings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
            }
            this.posTrackingService = Mockito.mock(classPositionTrackingService, (MockSettings)mockSettings);
            if (delete) {
                FileUtils.deleteRecursively((File)this.posTrackingServiceDir);
            }
        }
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("isRunning"), (Object)new AtomicBoolean(true));
        if (!this.config.callsRealMethods()) {
            BanList nameBans = (BanList)Mockito.mock(BanList.class);
            BanList ipBans = (BanList)Mockito.mock(BanList.class);
            ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("playerDataSerializer"), (Object)this.playerDataSerializer);
            ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("pluginManager"), (Object)this.pluginManager);
            if (this.posTrackingService != null) {
                Mockito.lenient().when(getPositionTrackingService.invoke((Object)this.server, new Object[0])).thenReturn(this.posTrackingService);
            }
            Mockito.lenient().when(this.server.getConfig(Mockito.anyString(), Mockito.any())).thenAnswer(call -> call.getArgument(1));
            Mockito.lenient().when((Object)this.server.getConfig()).thenReturn((Object)new Config());
            Mockito.lenient().when((Object)this.server.getPluginManager()).thenReturn((Object)this.pluginManager);
            Mockito.lenient().when((Object)this.server.getPlayerDataSerializer()).thenCallRealMethod();
            Mockito.lenient().when((Object)this.server.getConsoleSender()).thenReturn((Object)new ConsoleCommandSender());
            Mockito.lenient().when((Object)this.server.getNetwork()).thenReturn((Object)this.network);
            Mockito.lenient().when((Object)this.server.getEntityMetadata()).thenReturn((Object)this.entityMetadata);
            Mockito.lenient().when((Object)this.server.getPlayerMetadata()).thenReturn((Object)this.playerMetadata);
            Mockito.lenient().when((Object)this.server.getPlayerDataSerializer()).thenReturn((Object)this.playerDataSerializer);
            Mockito.lenient().when((Object)this.server.getLevelMetadata()).thenReturn((Object)this.levelMetadata);
            Mockito.lenient().when((Object)this.server.getQueryInformation()).thenReturn((Object)this.queryRegenerateEvent);
            Mockito.lenient().when((Object)this.server.getMaxPlayers()).thenReturn((Object)this.config.maxPlayers());
            Mockito.lenient().when((Object)this.server.getLogger()).thenCallRealMethod();
            Mockito.lenient().when((Object)this.server.getScheduler()).thenReturn((Object)this.serverScheduler);
            Mockito.lenient().when((Object)this.server.getNameBans()).thenReturn((Object)nameBans);
            Mockito.lenient().when((Object)this.server.getIPBans()).thenReturn((Object)ipBans);
            Mockito.lenient().when((Object)this.server.getLanguage()).thenReturn((Object)new BaseLang("eng"));
            Mockito.lenient().when((Object)this.server.isWhitelisted((String)Mockito.any())).thenReturn((Object)true);
            Mockito.lenient().when((Object)this.server.getOfflinePlayerData((UUID)Mockito.any(UUID.class), Mockito.anyBoolean())).thenCallRealMethod();
            Mockito.lenient().when((Object)this.server.getResourcePackManager()).thenReturn(Mockito.mock(ResourcePackManager.class));
            Mockito.lenient().when((Object)this.server.getCommandMap()).thenReturn(Mockito.mock(SimpleCommandMap.class));
            Mockito.lenient().when((Object)this.server.isRunning()).thenReturn((Object)true);
            if (this.config.createTempDir()) {
                String path = this.tempDir.getAbsolutePath() + "/";
                Mockito.lenient().when((Object)this.server.getDataPath()).thenReturn((Object)path);
                Mockito.lenient().when((Object)this.server.getFilePath()).thenReturn((Object)path);
                Mockito.lenient().when((Object)this.server.getPluginPath()).thenReturn((Object)(this.pluginsDir.getAbsolutePath() + "/"));
            }
        }
        if (!this.config.initPrivateFields()) {
            return this.server;
        }
        Set mocks = Sets.newMockSafeHashSet((Object[])new Object[0]);
        new MockScanner((Object)this, ServerMocker.class).addPreparedMocks(mocks);
        mocks.remove(this.server);
        final Field serverField = ServerMocker.class.getDeclaredField("server");
        MockUtil.injectMocks(serverField, (Set<Object>)mocks, (Object)this);
        Field instance = Server.class.getDeclaredField("instance");
        Object before = ReflectionUtil.getField(null, instance);
        ReflectionUtil.setField(null, instance, (Object)this.server);
        Config serverProperties = new Config();
        serverProperties.set("motd", (Object)"A PowerNukkit Server");
        serverProperties.set("sub-motd", (Object)"https://powernukkit.org");
        serverProperties.set("server-port", (Object)19132);
        serverProperties.set("server-ip", (Object)"0.0.0.0");
        serverProperties.set("view-distance", (Object)10);
        serverProperties.set("white-list", (Object)false);
        serverProperties.set("achievements", (Object)true);
        serverProperties.set("announce-player-achievements", (Object)true);
        serverProperties.set("spawn-protection", (Object)16);
        serverProperties.set("max-players", (Object)this.config.maxPlayers());
        serverProperties.set("allow-flight", (Object)false);
        serverProperties.set("spawn-animals", (Object)true);
        serverProperties.set("spawn-mobs", (Object)true);
        serverProperties.set("gamemode", (Object)0);
        serverProperties.set("force-gamemode", (Object)false);
        serverProperties.set("hardcore", (Object)false);
        serverProperties.set("pvp", (Object)true);
        serverProperties.set("difficulty", (Object)1);
        serverProperties.set("generator-settings", (Object)"");
        serverProperties.set("level-name", (Object)"world");
        serverProperties.set("level-seed", (Object)"");
        serverProperties.set("level-type", (Object)"DEFAULT");
        serverProperties.set("allow-nether", (Object)true);
        serverProperties.set("enable-query", (Object)true);
        serverProperties.set("enable-rcon", (Object)false);
        serverProperties.set("rcon.password", (Object)"random");
        serverProperties.set("auto-save", (Object)true);
        serverProperties.set("force-resources", (Object)false);
        serverProperties.set("xbox-auth", (Object)true);
        Config nukkitYml = new Config();
        try (InputStream in = Server.class.getResourceAsStream("/default-nukkit.yml");){
            nukkitYml.load(in);
        }
        if (this.posTrackingService != null && positionTrackingServiceField != null) {
            ReflectionUtil.setField((Object)this.server, positionTrackingServiceField, this.posTrackingService);
        }
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("properties"), (Object)serverProperties);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("config"), (Object)nukkitYml);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("operators"), (Object)new Config());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("whitelist"), (Object)new Config());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("ignoredPackets"), new HashSet());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("profilingTickrate"), (Object)20);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("tickAverage"), (Object)new float[]{20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f, 20.0f});
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("useAverage"), (Object)new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("maxTick"), (Object)20);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("redstoneEnabled"), (Object)true);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("networkCompressionLevel"), (Object)7);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("autoTickRateLimit"), (Object)20);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("baseTickRate"), (Object)1);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("difficulty"), (Object)1);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("autoSaveTicks"), (Object)6000);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("uniquePlayers"), new HashSet());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("players"), new HashMap());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("playerList"), new HashMap());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("currentThread"), (Object)Thread.currentThread());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("filePath"), (Object)(this.tempDir.getAbsolutePath() + "/"));
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("dataPath"), (Object)(this.tempDir.getAbsolutePath() + "/"));
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("pluginPath"), (Object)(this.pluginsDir.getAbsolutePath() + "/"));
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("consoleSender"), (Object)new ConsoleCommandSender());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("serviceManager"), (Object)new NKServiceManager());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("banByName"), (Object)new BanList(this.bannedPlayersFile.getAbsolutePath()));
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("banByIP"), (Object)new BanList(this.bannedIpsFile.getAbsolutePath()));
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("maxPlayers"), (Object)20);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("baseLang"), (Object)this.baseLang);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("allowNether"), (Object)true);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("commandMap"), (Object)new SimpleCommandMap(this.server));
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("craftingManager"), (Object)new CraftingManager());
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("resourcePackManager"), (Object)new ResourcePackManager(this.resourcePacksDir));
        final Field levelArray = Server.class.getDeclaredField("levelArray");
        ReflectionUtil.setField((Object)this.server, levelArray, (Object)new Level[0]);
        ReflectionUtil.setField((Object)this.server, Server.class.getDeclaredField("levels"), (Object)new HashMap<Integer, Level>(){

            @Override
            public Level put(Integer key, Level value) {
                Level result = super.put(key, value);
                ReflectionUtil.setField((Object)ServerMocker.this.server, levelArray, (Object)this.values().toArray(new Level[0]));
                return result;
            }

            @Override
            public boolean remove(Object key, Object value) {
                boolean result = super.remove(key, value);
                ReflectionUtil.setField((Object)ServerMocker.this.server, levelArray, (Object)this.values().toArray(new Level[0]));
                return result;
            }

            @Override
            public Level remove(Object key) {
                Level result = (Level)super.remove(key);
                ReflectionUtil.setField((Object)serverField, levelArray, (Object)this.values().toArray(new Level[0]));
                return result;
            }
        });
        ReflectionUtil.setField(null, instance, before);
        return this.server;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public Server getServer() {
        return this.server;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public MockServer getConfig() {
        return this.config;
    }

    public void releaseResources() {
        if (this.tempDir != null) {
            FileUtils.deleteRecursively((File)this.tempDir);
        }
    }

    static {
        Field f;
        Method m;
        Class<?> c;
        try {
            c = Class.forName("cn.nukkit.positiontracking.PositionTrackingService");
            m = Server.class.getDeclaredMethod("getPositionTrackingService", new Class[0]);
            f = Server.class.getDeclaredField("positionTrackingService");
        }
        catch (ReflectiveOperationException ignored) {
            c = null;
            m = null;
            f = null;
        }
        classPositionTrackingService = c;
        getPositionTrackingService = m;
        positionTrackingServiceField = f;
    }
}

