/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.mocks;

import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.level.generator.Flat;
import java.util.concurrent.ThreadLocalRandom;
import org.apiguardian.api.API;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.powernukkit.tests.api.MockLevel;
import org.powernukkit.tests.api.ReflectionUtil;
import org.powernukkit.tests.junit.jupiter.PowerNukkitExtension;
import org.powernukkit.tests.memory.MemoryLevelProvider;
import org.powernukkit.tests.mocks.Mocker;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class LevelMocker
extends Mocker<Level> {
    final String levelName;
    MockLevel config;
    Level level;

    public LevelMocker() {
        this(ReflectionUtil.supply(() -> PowerNukkitExtension.class.getDeclaredField("defaults").getAnnotation(MockLevel.class)));
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public LevelMocker(MockLevel config) {
        this(config, config.name());
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public LevelMocker(MockLevel config, String levelName) {
        this.config = config;
        if (levelName.isEmpty()) {
            levelName = "TestLevel" + ThreadLocalRandom.current().nextInt(0, 1000000);
        }
        this.levelName = levelName;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public LevelMocker(String levelName) {
        this(ReflectionUtil.supply(() -> PowerNukkitExtension.class.getDeclaredField("defaults").getAnnotation(MockLevel.class)), levelName);
    }

    @Override
    public Level create() {
        String path = "memory/" + this.levelName;
        MemoryLevelProvider.generate(path, this.levelName, ThreadLocalRandom.current().nextLong(), Flat.class);
        this.level = (Level)Mockito.mock(Level.class, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).useConstructor(new Object[]{Server.getInstance(), this.levelName, path, MemoryLevelProvider.class}));
        this.level.initLevel();
        return this.level;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public String getLevelName() {
        return this.levelName;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public Level getLevel() {
        return this.level;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public MockLevel getConfig() {
        return this.config;
    }
}

