/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.mocks;

import cn.nukkit.entity.Entity;
import cn.nukkit.level.Level;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.powernukkit.tests.api.MockEntity;
import org.powernukkit.tests.api.ReflectionUtil;
import org.powernukkit.tests.junit.jupiter.PowerNukkitExtension;
import org.powernukkit.tests.mocks.AnnotationParser;
import org.powernukkit.tests.mocks.ChunkBoundMocker;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class EntityMocker
extends ChunkBoundMocker<Entity> {
    final MockEntity config;
    final Class<? extends Entity> fieldType;
    Entity entity;

    private static MockEntity defaultMockEntity() {
        return ReflectionUtil.supply(() -> PowerNukkitExtension.class.getDeclaredField("defaults").getAnnotation(MockEntity.class));
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public EntityMocker(Function<String, Level> levelSupplier) {
        this(levelSupplier, EntityMocker.defaultMockEntity());
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public EntityMocker(Function<String, Level> levelSupplier, MockEntity config) {
        this(levelSupplier, config.type(), config);
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.1")
    public EntityMocker(Function<String, Level> levelSupplier, Class<? extends Entity> fieldType) {
        this(levelSupplier, fieldType, EntityMocker.defaultMockEntity());
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.1")
    public EntityMocker(Function<String, Level> levelSupplier, Class<? extends Entity> fieldType, MockEntity config) {
        super(levelSupplier);
        this.fieldType = fieldType;
        this.config = config;
    }

    @Override
    protected String getLevelName() {
        return this.config.level();
    }

    @Override
    protected Vector3 getSpawnPos() {
        return AnnotationParser.parseVector3(this.config.position());
    }

    @Override
    public Entity create() {
        CompoundTag nbt = Entity.getDefaultNBT((Vector3)this.pos, (Vector3)new Vector3(), (float)this.config.yaw(), (float)this.config.pitch());
        this.entity = (Entity)Mockito.mock(this.fieldType, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).useConstructor(new Object[]{this.chunk, nbt}));
        this.entity.noDamageTicks = 0;
        return this.entity;
    }
}

