/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.mocks;

import cn.nukkit.level.Level;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.Vector3;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powernukkit.tests.mocks.Mocker;

@API(status=API.Status.EXPERIMENTAL, since="0.1.1")
public abstract class ChunkBoundMocker<T>
extends Mocker<T> {
    final Function<String, Level> levelSupplier;
    Level level;
    BaseFullChunk chunk;
    Vector3 pos;

    @API(status=API.Status.EXPERIMENTAL, since="0.1.1")
    protected ChunkBoundMocker(Function<String, Level> levelSupplier) {
        this.levelSupplier = levelSupplier;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.1")
    protected abstract String getLevelName();

    @API(status=API.Status.EXPERIMENTAL, since="0.1.1")
    protected abstract Vector3 getSpawnPos();

    @API(status=API.Status.EXPERIMENTAL, since="0.1.1")
    public void prepare() {
        this.level = this.levelSupplier.apply(this.getLevelName());
        this.pos = this.getSpawnPos();
        int chunkX = this.pos.getChunkX();
        int chunkZ = this.pos.getChunkZ();
        this.chunk = this.level.getChunk(chunkX, chunkZ);
        if (this.chunk == null) {
            this.chunk = (BaseFullChunk)Mockito.mock(BaseFullChunk.class);
            LevelProvider provider = (LevelProvider)Mockito.mock(LevelProvider.class);
            Mockito.lenient().when((Object)provider.getChunk(ArgumentMatchers.eq((int)chunkX), ArgumentMatchers.eq((int)chunkZ))).thenReturn((Object)this.chunk);
            Mockito.lenient().when((Object)provider.getLevel()).thenReturn((Object)this.level);
            ((BaseFullChunk)Mockito.lenient().doCallRealMethod().when((Object)this.chunk)).setPosition(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
            this.chunk.setPosition(chunkX, chunkZ);
            Mockito.lenient().when((Object)this.chunk.getProvider()).thenReturn((Object)provider);
        }
    }
}

