/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.memory;

import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.format.anvil.Chunk;
import cn.nukkit.level.format.anvil.ChunkSection;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.BaseLevelProvider;
import cn.nukkit.level.generator.Flat;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.ThreadCache;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apiguardian.api.API;
import org.iq80.leveldb.util.FileUtils;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class MemoryLevelProvider
extends BaseLevelProvider {
    private static final Map<Path, Prepared> preparedMap = new ConcurrentHashMap<Path, Prepared>();
    private final Long2ObjectMap<BaseFullChunk> savedChunks = new Long2ObjectLinkedOpenHashMap();
    private final Long2ObjectMap<BaseFullChunk> loadedChunks = new Long2ObjectLinkedOpenHashMap();

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static ChunkSection createChunkSection(int y) {
        return Anvil.createChunkSection((int)y);
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public MemoryLevelProvider(Level level, String pathString) throws IOException {
        super(level, Files.isRegularFile(Paths.get(pathString, "level.dat"), new LinkOption[0]) ? pathString : MemoryLevelProvider.trickConstructor());
        Prepared prepared;
        Path path = Paths.get(pathString, new String[0]);
        if (!super.getPath().equals(pathString)) {
            FileUtils.deleteRecursively((File)new File(super.getPath()));
            try {
                Field field = BaseLevelProvider.class.getDeclaredField("path");
                field.setAccessible(true);
                field.set((Object)this, pathString);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
            if (!preparedMap.containsKey(path)) {
                return;
            }
        }
        if ((prepared = preparedMap.get(path)) == null) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            prepared = new Prepared("TestLevel" + random.nextDouble(), random.nextLong(), Flat.class, new LinkedHashMap<String, String>());
        }
        this.levelData.putString("generatorName", prepared.getGenerator().getSimpleName().toLowerCase());
        this.levelData.putString("generatorOptions", "");
        this.levelData.putLong("RandomSeed", prepared.getSeed());
    }

    private static String trickConstructor() throws IOException {
        Path tempDir = Files.createTempDirectory("trick_for_BaseLevelProvider", new FileAttribute[0]);
        CompoundTag levelData = new CompoundTag("Data").putString("generatorName", "memory").putString("generatorOptions", "memory").putInt("SpawnX", 128).putInt("SpawnY", 70).putInt("SpawnZ", 128);
        try (FileOutputStream fos = new FileOutputStream(tempDir.resolve("level.dat").toFile());){
            NBTIO.writeGZIPCompressed((CompoundTag)new CompoundTag().putCompound("Data", levelData), (OutputStream)fos, (ByteOrder)ByteOrder.BIG_ENDIAN);
        }
        return tempDir.toString() + "/";
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static void reset() {
        preparedMap.clear();
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static void reset(Path path) {
        preparedMap.remove(path);
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static String getProviderName() {
        return "memory";
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static byte getProviderOrder() {
        return 0;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static boolean usesChunkSection() {
        return true;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static boolean isValid(String path) {
        return true;
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static void generate(String path, String name, long seed, Class<? extends Generator> generator) {
        MemoryLevelProvider.generate(path, name, seed, generator, new HashMap<String, String>());
    }

    @API(status=API.Status.EXPERIMENTAL, since="0.1.0")
    public static void generate(String path, String name, long seed, Class<? extends Generator> generator, Map<String, String> options) {
        preparedMap.put(Paths.get(path, new String[0]), new Prepared(name, seed, generator, new LinkedHashMap<String, String>(options)));
    }

    public BaseFullChunk loadChunk(long index, int chunkX, int chunkZ, boolean create) {
        BaseFullChunk chunk;
        if (!create) {
            chunk = (BaseFullChunk)this.savedChunks.get(index);
            if (chunk == null) {
                return null;
            }
        } else {
            chunk = (BaseFullChunk)this.savedChunks.computeIfAbsent(index, i -> this.getEmptyChunk(chunkX, chunkZ));
        }
        this.loadedChunks.put(index, (Object)chunk.clone());
        return chunk;
    }

    public AsyncTask requestChunkTask(int x, int z) {
        int n;
        int i;
        BinaryStream extraData;
        Map extra;
        Chunk chunk = (Chunk)this.getChunk(x, z, false);
        if (chunk == null) {
            throw new ChunkException("Invalid Chunk Set");
        }
        long timestamp = chunk.getChanges();
        byte[] blockEntities = new byte[]{};
        if (!chunk.getBlockEntities().isEmpty()) {
            ArrayList<CompoundTag> tagList = new ArrayList<CompoundTag>();
            for (Object blockEntity : chunk.getBlockEntities().values()) {
                if (!(blockEntity instanceof BlockEntitySpawnable)) continue;
                tagList.add(((BlockEntitySpawnable)blockEntity).getSpawnCompound());
            }
            try {
                blockEntities = NBTIO.write(tagList, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (boolean)true);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (!(extra = chunk.getBlockExtraDataArray()).isEmpty()) {
            extraData = new BinaryStream();
            extraData.putVarInt(extra.size());
            for (Map.Entry entry : extra.entrySet()) {
                extraData.putVarInt(((Integer)entry.getKey()).intValue());
                extraData.putLShort(((Integer)entry.getValue()).intValue());
            }
        } else {
            extraData = null;
        }
        BinaryStream stream = ((BinaryStream)ThreadCache.binaryStream.get()).reset();
        boolean bl = false;
        cn.nukkit.level.format.ChunkSection[] sections = chunk.getSections();
        for (i = sections.length - 1; i >= 0; --i) {
            if (sections[i].isEmpty()) continue;
            n = i + 1;
            break;
        }
        for (i = 0; i < n; ++i) {
            stream.put(sections[i].getBytes());
        }
        stream.put(chunk.getBiomeIdArray());
        stream.putByte((byte)0);
        if (extraData != null) {
            stream.put(extraData.getBuffer());
        } else {
            stream.putVarInt(0);
        }
        stream.put(blockEntities);
        this.getLevel().chunkRequestCallback(timestamp, x, z, n, stream.getBuffer());
        return null;
    }

    public BaseFullChunk getEmptyChunk(int x, int z) {
        return Chunk.getEmptyChunk((int)x, (int)z, (LevelProvider)this);
    }

    public void saveChunk(int x, int z) {
        long index = Level.chunkHash((int)x, (int)z);
        BaseFullChunk chunk = (BaseFullChunk)this.loadedChunks.get(index);
        if (chunk != null) {
            this.savedChunks.put(index, (Object)chunk.clone());
        }
    }

    public void saveChunk(int x, int z, FullChunk chunk) {
        if (!(chunk instanceof BaseFullChunk)) {
            throw new UnsupportedOperationException("The chunk is not BaseFullChunk!");
        }
        this.savedChunks.put(Level.chunkHash((int)x, (int)z), (Object)((BaseFullChunk)chunk).clone());
    }

    private static class Prepared {
        private String name;
        private long seed;
        private Class<? extends Generator> generator;
        private Map<String, String> options;

        public String getName() {
            return this.name;
        }

        public long getSeed() {
            return this.seed;
        }

        public Class<? extends Generator> getGenerator() {
            return this.generator;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSeed(long seed) {
            this.seed = seed;
        }

        public void setGenerator(Class<? extends Generator> generator) {
            this.generator = generator;
        }

        public void setOptions(Map<String, String> options) {
            this.options = options;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prepared)) {
                return false;
            }
            Prepared other = (Prepared)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.getSeed() != other.getSeed()) {
                return false;
            }
            Class<? extends Generator> this$generator = this.getGenerator();
            Class<? extends Generator> other$generator = other.getGenerator();
            if (this$generator == null ? other$generator != null : !this$generator.equals(other$generator)) {
                return false;
            }
            Map<String, String> this$options = this.getOptions();
            Map<String, String> other$options = other.getOptions();
            return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Prepared;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $seed = this.getSeed();
            result = result * 59 + (int)($seed >>> 32 ^ $seed);
            Class<? extends Generator> $generator = this.getGenerator();
            result = result * 59 + ($generator == null ? 43 : $generator.hashCode());
            Map<String, String> $options = this.getOptions();
            result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
            return result;
        }

        public String toString() {
            return "MemoryLevelProvider.Prepared(name=" + this.getName() + ", seed=" + this.getSeed() + ", generator=" + this.getGenerator() + ", options=" + this.getOptions() + ")";
        }

        public Prepared(String name, long seed, Class<? extends Generator> generator, Map<String, String> options) {
            this.name = name;
            this.seed = seed;
            this.generator = generator;
            this.options = options;
        }
    }
}

