/*
 * Decompiled with CFR 0.152.
 */
package org.powernukkit.tests.api;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.powernukkit.tests.api.ReflectiveRunnable;
import org.powernukkit.tests.api.ReflectiveSupplier;

@API(since="0.1.0", status=API.Status.EXPERIMENTAL)
public class ReflectionUtil {
    private ReflectionUtil() {
        throw new UnsupportedOperationException();
    }

    @API(since="0.1.0", status=API.Status.EXPERIMENTAL)
    public static <T> T getField(@Nullable Object instance, Field field) {
        return (T)ReflectionUtil.supply(() -> {
            field.setAccessible(true);
            return field.get(instance);
        });
    }

    @API(since="0.1.0", status=API.Status.EXPERIMENTAL)
    public static <T> T getField(Object instance, String name) {
        return (T)ReflectionUtil.supply(() -> ReflectionUtil.getField(instance, instance.getClass().getField(name)));
    }

    @API(since="0.1.0", status=API.Status.EXPERIMENTAL)
    public static void setField(@Nullable Object instance, Field field, @Nullable Object value) {
        ReflectionUtil.execute(() -> {
            field.setAccessible(true);
            field.set(instance, value);
        });
    }

    @API(since="0.1.0", status=API.Status.EXPERIMENTAL)
    public static void setField(Object instance, String name, @Nullable Object value) {
        ReflectionUtil.execute(() -> ReflectionUtil.setField(instance, instance.getClass().getField(name), value));
    }

    @API(since="0.1.0", status=API.Status.EXPERIMENTAL)
    public static <T> T supply(ReflectiveSupplier<T> supplier) {
        return supplier.get();
    }

    @API(since="0.1.0", status=API.Status.EXPERIMENTAL)
    public static void execute(ReflectiveRunnable runnable) {
        runnable.run();
    }
}

