/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import org.powermock.modules.testng.internal.ExpectedExceptionsExtractor;
import org.testng.annotations.Test;

public class PowerMockExpectedExceptionsExtractorImpl
implements ExpectedExceptionsExtractor {
    public String[] getPackagesToIgnore(AnnotatedElement element) {
        LinkedList<String> ignoredPackages = new LinkedList<String>();
        if (element instanceof Class) {
            Class klazz = (Class)element;
            for (Method method : klazz.getMethods()) {
                Class[] ignores;
                Test annotation = method.getAnnotation(Test.class);
                if (annotation == null || (ignores = annotation.expectedExceptions()) == null) continue;
                for (Class ignorePackage : ignores) {
                    ignoredPackages.add(ignorePackage.getName());
                }
            }
            Class superclass = klazz.getSuperclass();
            if (superclass != null && !superclass.equals(Object.class)) {
                String[] packagesToIgnore = this.getPackagesToIgnore(superclass);
                ignoredPackages.addAll(Arrays.asList(packagesToIgnore));
            }
        }
        return ignoredPackages.toArray(new String[ignoredPackages.size()]);
    }
}

