/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.modules.testng.internal.PowerMockClassloaderObjectFactory;
import org.testng.IObjectFactory;
import org.testng.internal.ObjectFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockObjectFactory
implements IObjectFactory {
    private PowerMockClassloaderObjectFactory powerMockObjectFactory = new PowerMockClassloaderObjectFactory();
    private ObjectFactoryImpl defaultObjectFactory = new ObjectFactoryImpl();

    public Object newInstance(Constructor constructor, Object ... params) {
        Class testClass = constructor.getDeclaringClass();
        Object testInstance = this.hasPowerMockAnnotation(testClass) ? this.powerMockObjectFactory.newInstance(constructor, params) : this.defaultObjectFactory.newInstance(constructor, params);
        return testInstance;
    }

    private boolean hasPowerMockAnnotation(Class<?> testClass) {
        return this.isClassAnnotatedWithPowerMockAnnotation(testClass) || this.anyMethodInClassHasPowerMockAnnotation(testClass);
    }

    private boolean anyMethodInClassHasPowerMockAnnotation(Class<?> testClass) {
        Method[] methods;
        for (Method method : methods = testClass.getMethods()) {
            if (!method.isAnnotationPresent(PrepareForTest.class) && !method.isAnnotationPresent(SuppressStaticInitializationFor.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isClassAnnotatedWithPowerMockAnnotation(Class<?> testClass) {
        return testClass.isAnnotationPresent(PrepareForTest.class) || testClass.isAnnotationPresent(SuppressStaticInitializationFor.class);
    }
}

