/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import org.powermock.modules.agent.AgentInitialization;
import org.powermock.modules.agent.DefinalizingClassTransformer;
import org.powermock.modules.agent.PowerMockClassTransformer;
import org.powermock.utils.JavaVersion;

public final class PowerMockAgent {
    static final String javaSpecVersion = System.getProperty("java.specification.version");
    static final boolean jdk6OrLater = JavaVersion.JAVA_RECENT.atLeast(JavaVersion.JAVA_1_6);
    private static final PowerMockClassTransformer classTransformer = new PowerMockClassTransformer();
    private static Instrumentation instrumentation;

    private PowerMockAgent() {
    }

    public static void premain(String agentArgs, Instrumentation inst) throws Exception {
        PowerMockAgent.initialize(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) throws Exception {
        PowerMockAgent.initialize(agentArgs, inst);
    }

    private static void initialize(String agentArgs, Instrumentation inst) throws IOException {
        instrumentation = inst;
        inst.addTransformer(new DefinalizingClassTransformer(), false);
        inst.addTransformer(classTransformer, true);
    }

    public static PowerMockClassTransformer getClasstransformer() {
        return classTransformer;
    }

    public static Instrumentation instrumentation() {
        PowerMockAgent.verifyInitialization();
        return instrumentation;
    }

    public static void verifyInitialization() {
        if (instrumentation == null) {
            new AgentInitialization().initializeAccordingToJDKVersion();
        }
    }

    public static boolean initializeIfNeeded() {
        if (instrumentation == null) {
            try {
                new AgentInitialization().initializeAccordingToJDKVersion();
                return true;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return false;
    }

    public static void initializeIfPossible() {
        if (jdk6OrLater) {
            PowerMockAgent.initializeIfNeeded();
        }
    }
}

