/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.spring.pulsar;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.SubscriptionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import poussecafe.pulsar.PublicationTopicChooser;
import poussecafe.pulsar.PulsarMessaging;
import poussecafe.pulsar.PulsarMessagingConfiguration;

@Configuration
public class SpringPulsarConfig {
    @Bean
    public PulsarMessaging pulsarMessaging(@Value(value="${poussecafe.spring.pulsar.broker:pulsar://localhost:6650}") String brokerUrl, @Value(value="${poussecafe.spring.pulsar.subscriptionTopics:pousse-cafe}") String subscriptionTopics, @Value(value="${poussecafe.spring.pulsar.subscriptionName:pousse-cafe}") String subscriptionName, @Value(value="${poussecafe.spring.pulsar.defaultPublicationTopic:pousse-cafe}") String defaultPublicationTopic, @Value(value="${poussecafe.spring.pulsar.subscriptionType:Shared}") String subscriptionType, @Value(value="${poussecafe.spring.pulsar.statsIntervalInS:-1}") String statsIntervalInS, @Value(value="${poussecafe.spring.pulsar.sendAsynchronously:false}") String sendAsynchronously, @Autowired(required=false) PublicationTopicChooser publicationTopicChooser) {
        PulsarMessagingConfiguration.Builder configurationBuilder = new PulsarMessagingConfiguration.Builder().brokerUrl(brokerUrl).subscriptionTopics(this.parseSubscriptionTopics(subscriptionTopics)).subscriptionName(subscriptionName).defaultPublicationTopic(defaultPublicationTopic).subscriptionType(SubscriptionType.valueOf((String)subscriptionType)).statsInterval(Duration.ofSeconds(Long.valueOf(statsIntervalInS))).sendAsynchronously(Boolean.valueOf(sendAsynchronously).booleanValue());
        if (publicationTopicChooser != null) {
            configurationBuilder.publicationTopicChooser(publicationTopicChooser);
        }
        return new PulsarMessaging(configurationBuilder.build());
    }

    private List<String> parseSubscriptionTopics(String subscriptionTopics) {
        return Arrays.asList(subscriptionTopics.split(",")).stream().map(String::trim).collect(Collectors.toList());
    }
}

