/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.servicedoc;

import javax.lang.model.element.TypeElement;
import poussecafe.doc.doclet.ClassDocPredicates;
import poussecafe.doc.model.ComponentDoc;
import poussecafe.doc.model.ComponentDocFactory;
import poussecafe.doc.model.ModuleComponentDoc;
import poussecafe.doc.model.moduledoc.ModuleDoc;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.doc.model.moduledoc.ModuleDocRepository;
import poussecafe.doc.model.servicedoc.ServiceDoc;
import poussecafe.doc.model.servicedoc.ServiceDocId;
import poussecafe.domain.AggregateFactory;
import poussecafe.domain.DomainException;
import poussecafe.domain.Service;

public class ServiceDocFactory
extends AggregateFactory<ServiceDocId, ServiceDoc, ServiceDoc.Attributes> {
    private ComponentDocFactory componentDocFactory;
    private ModuleDocRepository moduleDocRepository;
    private ClassDocPredicates classDocPredicates;

    public ServiceDoc newServiceDoc(ModuleDocId moduleDocId, TypeElement classDoc) {
        if (!this.isServiceDoc(classDoc)) {
            throw new DomainException("Class " + classDoc.getQualifiedName() + " is not a service");
        }
        String name = classDoc.getSimpleName().toString();
        ServiceDocId id = ServiceDocId.ofClassName(classDoc.getQualifiedName().toString());
        ServiceDoc serviceDoc = (ServiceDoc)this.newAggregateWithId((Object)id);
        String moduleName = ((ComponentDoc)((ModuleDoc.Attributes)((ModuleDoc)this.moduleDocRepository.get((Object)moduleDocId)).attributes()).componentDoc().value()).name();
        ((ServiceDoc.Attributes)serviceDoc.attributes()).moduleComponentDoc().value((Object)new ModuleComponentDoc.Builder().moduleDocId(moduleDocId).moduleName(moduleName).componentDoc(this.componentDocFactory.buildDoc(name, classDoc)).build());
        return serviceDoc;
    }

    public boolean isServiceDoc(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperinterface(classDoc, Service.class);
    }
}

