/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.processstepdoc;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import poussecafe.doc.model.domainprocessdoc.ComponentMethodName;
import poussecafe.domain.DomainException;
import poussecafe.util.Equality;

public class StepMethodSignature {
    private ComponentMethodName componentMethodName;
    private Optional<String> consumedEventName = Optional.empty();

    private StepMethodSignature() {
    }

    public ComponentMethodName componentMethodName() {
        return this.componentMethodName;
    }

    public Optional<String> consumedEventName() {
        return this.consumedEventName;
    }

    public String toString() {
        if (this.consumedEventName.isPresent()) {
            return this.componentMethodName.toString() + "(" + this.consumedEventName.get() + ")";
        }
        return this.componentMethodName.toString() + "()";
    }

    public static StepMethodSignature parse(String signatureString) {
        int indexOfOpen = signatureString.indexOf(40);
        int indexOfClose = signatureString.indexOf(41);
        if (indexOfOpen == -1 || indexOfClose == -1 || indexOfClose != signatureString.length() - 1 || indexOfOpen > indexOfClose) {
            throw new DomainException("Wrong signature format: " + signatureString);
        }
        ComponentMethodName aggregateMethodName = ComponentMethodName.parse(signatureString.substring(0, indexOfOpen));
        String consumedEventName = signatureString.substring(indexOfOpen + 1, indexOfClose);
        Optional<String> consumedEvent = Optional.empty();
        if (consumedEventName.length() > 0) {
            consumedEvent = Optional.of(consumedEventName);
        }
        return new Builder().componentMethodName(aggregateMethodName).consumedMessageName(consumedEvent).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.componentMethodName).append(this.consumedEventName).build();
    }

    public boolean equals(Object obj) {
        return Equality.referenceEquals((Object)this, (Object)obj).orElse(other -> new EqualsBuilder().append((Object)this.componentMethodName, (Object)other.componentMethodName).append(this.consumedEventName, other.consumedEventName).build());
    }

    public static class Builder {
        private StepMethodSignature signature = new StepMethodSignature();

        public Builder componentMethodName(ComponentMethodName componentMethodName) {
            this.signature.componentMethodName = componentMethodName;
            return this;
        }

        public Builder consumedMessageName(Optional<String> consumedEventName) {
            this.signature.consumedEventName = consumedEventName;
            return this;
        }

        public StepMethodSignature build() {
            Objects.requireNonNull(this.signature.componentMethodName);
            Objects.requireNonNull(this.signature.consumedEventName);
            return this.signature;
        }
    }
}

