/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.processstepdoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.collection.Collections;
import poussecafe.discovery.DefaultProcess;
import poussecafe.discovery.MessageListener;
import poussecafe.discovery.ProducesEvent;
import poussecafe.discovery.ProducesEvents;
import poussecafe.doc.annotations.AnnotationUtils;
import poussecafe.doc.doclet.ClassDocPredicates;
import poussecafe.doc.doclet.Logger;
import poussecafe.doc.model.AnnotationsResolver;
import poussecafe.doc.model.ComponentDoc;
import poussecafe.doc.model.ComponentDocFactory;
import poussecafe.doc.model.DocletAccess;
import poussecafe.doc.model.ModuleComponentDoc;
import poussecafe.doc.model.aggregatedoc.AggregateDoc;
import poussecafe.doc.model.aggregatedoc.AggregateDocFactory;
import poussecafe.doc.model.aggregatedoc.AggregateDocId;
import poussecafe.doc.model.aggregatedoc.AggregateDocRepository;
import poussecafe.doc.model.domainprocessdoc.ComponentMethodName;
import poussecafe.doc.model.domainprocessdoc.DomainProcessDocFactory;
import poussecafe.doc.model.moduledoc.ModuleDoc;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.doc.model.moduledoc.ModuleDocRepository;
import poussecafe.doc.model.processstepdoc.ConsumedMessageExtractor;
import poussecafe.doc.model.processstepdoc.NameRequired;
import poussecafe.doc.model.processstepdoc.ProcessStepDoc;
import poussecafe.doc.model.processstepdoc.ProcessStepDocFactory;
import poussecafe.doc.model.processstepdoc.ProcessStepDocId;
import poussecafe.doc.model.processstepdoc.StepMethodSignature;
import poussecafe.domain.DomainEvent;
import poussecafe.domain.Service;
import poussecafe.exception.PousseCafeException;
import poussecafe.source.generation.NamingConventions;

public class ProcessStepDocExtractor
implements Service {
    private ModuleDocRepository moduleDocRepository;
    private DocletAccess docletAccess;
    private DomainProcessDocFactory domainProcessDocFactory;
    private AnnotationsResolver annotationsResolver;
    private ConsumedMessageExtractor consumedMessageExtractor;
    private static final String CONSUMED_BY_EXTERNAL_ELEMENT_NAME = "consumedByExternal";
    private DocletEnvironment docletEnvironment;
    private ClassDocPredicates classDocPredicates;
    private ProcessStepDocFactory messageListenerDocFactory;
    private ComponentDocFactory componentDocFactory;
    private AggregateDocFactory aggregateDocFactory;
    private AggregateDocRepository aggregateDocRepository;

    public List<ProcessStepDoc> extractProcessStepDocs(ModuleDocId moduleDocId, TypeElement classDoc) {
        String moduleName = ((ComponentDoc)((ModuleDoc.Attributes)((ModuleDoc)this.moduleDocRepository.get((Object)moduleDocId)).attributes()).componentDoc().value()).name();
        ArrayList<ProcessStepDoc> stepDocs = new ArrayList<ProcessStepDoc>();
        for (ExecutableElement methodDoc : this.docletAccess.methods(classDoc)) {
            if (!this.isProcessStep(methodDoc)) continue;
            List<String> customStepSignatures = this.annotationsResolver.step(methodDoc);
            if (!customStepSignatures.isEmpty()) {
                stepDocs.addAll(this.extractCustomSteps(moduleDocId, moduleName, methodDoc));
                continue;
            }
            stepDocs.add(this.extractDeclaredStep(moduleDocId, moduleName, methodDoc));
        }
        return stepDocs;
    }

    private boolean isProcessStep(ExecutableElement methodDoc) {
        if (this.domainProcessDocFactory.isDomainProcessDoc((TypeElement)methodDoc.getEnclosingElement())) {
            return this.annotationsResolver.isStep(methodDoc);
        }
        Optional<String> consumedMessage = this.consumedMessageExtractor.consumedMessage(methodDoc);
        Set<NameRequired> producedEvents = this.extractProducedEvents(methodDoc);
        return this.annotationsResolver.isStep(methodDoc) || this.docletAccess.isPublic(methodDoc) && (consumedMessage.isPresent() || !producedEvents.isEmpty());
    }

    private Set<NameRequired> extractProducedEvents(ExecutableElement methodDoc) {
        HashSet<NameRequired> producedEvents = new HashSet<NameRequired>();
        List<String> javadocTagEvents = this.annotationsResolver.event(methodDoc);
        if (!javadocTagEvents.isEmpty()) {
            Logger.warn("@event tag is deprecated, use @ProducesEvent annotation instead", new Object[0]);
            producedEvents.addAll(javadocTagEvents.stream().map(NameRequired::required).collect(Collectors.toList()));
        }
        List<AnnotationMirror> producesEventAnnotations = this.producesEventAnnotations(methodDoc);
        for (AnnotationMirror mirror : producesEventAnnotations) {
            NameRequired nameRequired = this.nameRequired(mirror);
            producedEvents.add(nameRequired);
        }
        return producedEvents;
    }

    private List<AnnotationMirror> producesEventAnnotations(ExecutableElement methodDoc) {
        return AnnotationUtils.annotations(methodDoc, ProducesEvent.class, ProducesEvents.class);
    }

    private NameRequired nameRequired(AnnotationMirror producesEventMirror) {
        Optional<AnnotationValue> producesEventValue = AnnotationUtils.value(producesEventMirror, "value");
        Element valueElement = producesEventValue.map(AnnotationValue::getValue).map(value -> this.docletAccess.getTypesUtils().asElement((TypeMirror)value)).orElseThrow();
        boolean required = this.required(producesEventMirror);
        NameRequired nameRequired = required ? NameRequired.required(valueElement.getSimpleName().toString()) : NameRequired.optional(valueElement.getSimpleName().toString());
        return nameRequired;
    }

    private boolean required(AnnotationMirror producesEventMirror) {
        Optional<AnnotationValue> producesEventRequired = AnnotationUtils.value(producesEventMirror, "required");
        boolean required = producesEventRequired.isPresent() ? (Boolean)producesEventRequired.get().getValue() : true;
        return required;
    }

    private List<ProcessStepDoc> extractCustomSteps(ModuleDocId moduleDocId, String moduleName, ExecutableElement methodDoc) {
        ArrayList<ProcessStepDoc> stepDocs = new ArrayList<ProcessStepDoc>();
        Set<String> processNames = this.processNames(methodDoc);
        Set<NameRequired> producedEvents = this.extractProducedEvents(methodDoc);
        Set<String> fromExternals = this.extractFromExternals(methodDoc);
        Set<String> toExternals = this.extractToExternals(methodDoc);
        Map<NameRequired, List<String>> toExternalsByEvent = this.extractToExternalsByEvent(methodDoc);
        List<StepMethodSignature> methodSignatures = this.customStepsSignatures(methodDoc);
        for (StepMethodSignature signature : methodSignatures) {
            Logger.info("Extracting custom step " + signature, new Object[0]);
            ProcessStepDocId messageListenerDocId = new ProcessStepDocId(signature.toString());
            ModuleComponentDoc moduleComponentDoc = new ModuleComponentDoc.Builder().moduleDocId(moduleDocId).moduleName(moduleName).componentDoc(new ComponentDoc.Builder().name(signature.toString()).description(this.annotationsResolver.renderCommentBody(methodDoc)).build()).build();
            ProcessStepDoc processStepDoc = this.messageListenerDocFactory.createMessageListenerDoc(messageListenerDocId, moduleComponentDoc);
            ((ProcessStepDoc.Attributes)processStepDoc.attributes()).processNames().value(processNames);
            ((ProcessStepDoc.Attributes)processStepDoc.attributes()).stepMethodSignature().value(Optional.of(signature));
            ((ProcessStepDoc.Attributes)processStepDoc.attributes()).producedEvents().value(producedEvents);
            ((ProcessStepDoc.Attributes)processStepDoc.attributes()).fromExternals().value(fromExternals);
            ((ProcessStepDoc.Attributes)processStepDoc.attributes()).toExternals().value(toExternals);
            ((ProcessStepDoc.Attributes)processStepDoc.attributes()).toExternalsByEvent().value(toExternalsByEvent);
            stepDocs.add(processStepDoc);
        }
        return stepDocs;
    }

    private Set<String> extractToExternals(ExecutableElement methodDoc) {
        HashSet<String> toExternals = new HashSet<String>();
        List<String> javadocTagToExternals = this.annotationsResolver.toExternal(methodDoc);
        if (!javadocTagToExternals.isEmpty()) {
            Logger.warn("@to_external tag is deprecated, use @ProducesEvent annotation and set consumedByExternal element instead", new Object[0]);
            toExternals.addAll(javadocTagToExternals);
        }
        return toExternals;
    }

    private Set<String> extractFromExternals(ExecutableElement methodDoc) {
        Optional<AnnotationValue> optionalAnnotationValue;
        Optional<AnnotationMirror> annotationMirror;
        HashSet<String> fromExternals = new HashSet<String>();
        List<String> javadocTagToExternals = this.annotationsResolver.fromExternal(methodDoc);
        if (!javadocTagToExternals.isEmpty()) {
            Logger.warn("@from_external tag is deprecated, use @MessageListener annotation and set consumesFromExternal element instead", new Object[0]);
            fromExternals.addAll(javadocTagToExternals);
        }
        if ((annotationMirror = AnnotationUtils.annotation(methodDoc, MessageListener.class)).isPresent() && (optionalAnnotationValue = AnnotationUtils.value(annotationMirror.get(), "consumesFromExternal")).isPresent()) {
            List annotationValue = (List)optionalAnnotationValue.get().getValue();
            fromExternals.addAll(annotationValue.stream().map(external -> (String)external.getValue()).collect(Collectors.toList()));
        }
        return fromExternals;
    }

    private Map<NameRequired, List<String>> extractToExternalsByEvent(ExecutableElement methodDoc) {
        HashMap<NameRequired, List<String>> toExternals = new HashMap<NameRequired, List<String>>();
        List<AnnotationMirror> producesEventAnnotations = this.producesEventAnnotations(methodDoc);
        for (AnnotationMirror mirror : producesEventAnnotations) {
            NameRequired nameRequired = this.nameRequired(mirror);
            Optional<AnnotationValue> consumedByExternal = AnnotationUtils.value(mirror, CONSUMED_BY_EXTERNAL_ELEMENT_NAME);
            if (!consumedByExternal.isPresent()) continue;
            List externals = (List)consumedByExternal.get().getValue();
            toExternals.put(nameRequired, externals.stream().map(annotationValue -> (String)annotationValue.getValue()).collect(Collectors.toList()));
        }
        return toExternals;
    }

    private List<StepMethodSignature> customStepsSignatures(ExecutableElement methodDoc) {
        List<String> customStepSignatures = this.annotationsResolver.step(methodDoc);
        if (this.domainProcessDocFactory.isDomainProcessDoc((TypeElement)methodDoc.getEnclosingElement())) {
            if (customStepSignatures.size() != 1) {
                throw new PousseCafeException("Domain processes listeners must be tagged with a single step");
            }
            Optional<String> consumedEvent = this.consumedEvent(methodDoc);
            ComponentMethodName componentMethodName = ComponentMethodName.parse(customStepSignatures.get(0));
            return Arrays.asList(new StepMethodSignature.Builder().componentMethodName(componentMethodName).consumedMessageName(consumedEvent).build());
        }
        return customStepSignatures.stream().map(StepMethodSignature::parse).collect(Collectors.toList());
    }

    private Optional<String> consumedEvent(ExecutableElement methodDoc) {
        List<? extends VariableElement> parameters = methodDoc.getParameters();
        if (parameters.isEmpty()) {
            return Optional.empty();
        }
        TypeMirror firstParameterType = parameters.get(0).asType();
        Element firstParameterElement = this.docletEnvironment.getTypeUtils().asElement(firstParameterType);
        if (firstParameterElement instanceof TypeElement) {
            TypeElement firstParameterTypeElement = (TypeElement)firstParameterElement;
            if (this.classDocPredicates.documentsWithSuperinterface(firstParameterTypeElement, DomainEvent.class)) {
                return Optional.of(firstParameterTypeElement.getQualifiedName().toString());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Set<String> processNames(ExecutableElement methodDoc) {
        HashSet<String> processNames = new HashSet<String>(this.annotationsResolver.process(methodDoc));
        processNames.addAll(this.namesFromMessageListenerAnnotation(methodDoc));
        TypeElement containingClass = (TypeElement)methodDoc.getEnclosingElement();
        if (this.domainProcessDocFactory.isDomainProcessDoc(containingClass)) {
            return Collections.asSet((Object[])new String[]{this.domainProcessDocFactory.name(containingClass)});
        }
        if (!processNames.isEmpty()) {
            return java.util.Collections.unmodifiableSet(processNames);
        }
        return java.util.Collections.singleton(DefaultProcess.class.getSimpleName());
    }

    private List<String> namesFromMessageListenerAnnotation(ExecutableElement methodDoc) {
        Optional<AnnotationMirror> annotationMirror = AnnotationUtils.annotation(methodDoc, MessageListener.class);
        if (annotationMirror.isPresent()) {
            Optional<AnnotationValue> value = AnnotationUtils.value(annotationMirror.get(), "processes");
            if (value.isPresent()) {
                List processes = (List)value.get().getValue();
                return processes.stream().map(processValue -> this.docletAccess.getTypesUtils().asElement((TypeMirror)processValue.getValue())).map(process -> process.getSimpleName().toString()).collect(Collectors.toList());
            }
            return java.util.Collections.emptyList();
        }
        return java.util.Collections.emptyList();
    }

    private ProcessStepDoc extractDeclaredStep(ModuleDocId moduleDocId, String moduleName, ExecutableElement methodDoc) {
        Logger.info("Extracting declared step from method " + methodDoc.getSimpleName().toString(), new Object[0]);
        Set<String> processNames = this.processNames(methodDoc);
        Set<NameRequired> producedEvents = this.extractProducedEvents(methodDoc);
        Set<String> fromExternals = this.extractFromExternals(methodDoc);
        Set<String> toExternals = this.extractToExternals(methodDoc);
        Map<NameRequired, List<String>> toExternalsByEvent = this.extractToExternalsByEvent(methodDoc);
        Optional<String> consumedMessage = this.consumedMessageExtractor.consumedMessage(methodDoc);
        TypeElement enclosingType = (TypeElement)methodDoc.getEnclosingElement();
        String componentName = this.listenerContainerName(enclosingType);
        StepMethodSignature stepMethodSignature = new StepMethodSignature.Builder().componentMethodName(new ComponentMethodName.Builder().componentName(componentName).methodName(methodDoc.getSimpleName().toString()).build()).consumedMessageName(consumedMessage).build();
        AggregateDocId aggregate = this.declaringAggregate(methodDoc);
        ProcessStepDocId id = new ProcessStepDocId(stepMethodSignature);
        ModuleComponentDoc moduleComponentDoc = new ModuleComponentDoc.Builder().moduleDocId(moduleDocId).componentDoc(this.componentDocFactory.buildDoc(id.stringValue(), methodDoc)).moduleName(moduleName).build();
        ProcessStepDoc processStepDoc = this.messageListenerDocFactory.createMessageListenerDoc(id, moduleComponentDoc);
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).processNames().value(processNames);
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).stepMethodSignature().value(Optional.of(stepMethodSignature));
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).producedEvents().value(producedEvents);
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).fromExternals().value(fromExternals);
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).toExternals().value(toExternals);
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).toExternalsByEvent().value(toExternalsByEvent);
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).aggregate().value(Optional.of(aggregate));
        String aggregateName = ((ModuleComponentDoc)((AggregateDoc.Attributes)((AggregateDoc)this.aggregateDocRepository.get((Object)aggregate)).attributes()).moduleComponentDoc().value()).componentDoc().name();
        ((ProcessStepDoc.Attributes)processStepDoc.attributes()).aggregateName().value(Optional.of(aggregateName));
        return processStepDoc;
    }

    private String listenerContainerName(TypeElement enclosingType) {
        try {
            Element potentialContainer;
            String componentName = this.aggregateDocFactory.isStandaloneRoot(enclosingType) ? NamingConventions.aggregateNameFromSimpleRootName((String)enclosingType.getSimpleName().toString()) : (this.aggregateDocFactory.isStandaloneFactory(enclosingType) ? NamingConventions.aggregateNameFromSimpleFactoryName((String)enclosingType.getSimpleName().toString()) : (this.aggregateDocFactory.isStandaloneRepository(enclosingType) ? NamingConventions.aggregateNameFromSimpleRepositoryName((String)enclosingType.getSimpleName().toString()) : ((potentialContainer = enclosingType.getEnclosingElement()) instanceof TypeElement && this.aggregateDocFactory.isContainer((TypeElement)potentialContainer) ? potentialContainer.getSimpleName().toString() : enclosingType.getSimpleName().toString())));
            return componentName;
        }
        catch (IllegalArgumentException e) {
            Logger.warn("Listener container {} does not follow naming conventions", enclosingType.getQualifiedName().toString(), e);
            return enclosingType.getSimpleName().toString();
        }
    }

    private AggregateDocId declaringAggregate(ExecutableElement methodDoc) {
        TypeElement enclosingType = (TypeElement)methodDoc.getEnclosingElement();
        TypeElement aggregateType = this.aggregateDocFactory.isFactoryDoc(enclosingType) ? this.aggregateDocFactory.aggregateTypeElementOfFactory(enclosingType) : (this.aggregateDocFactory.isRepositoryDoc(enclosingType) ? this.aggregateDocFactory.aggregateTypeElementOfRepository(enclosingType) : (this.aggregateDocFactory.extendsAggregateRoot(enclosingType) ? this.aggregateDocFactory.aggregateTypeElementOfRoot(enclosingType) : enclosingType));
        return AggregateDocId.ofClassName(aggregateType.getQualifiedName().toString());
    }
}

