/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.processstepdoc;

import java.util.Iterator;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.doc.doclet.ClassDocPredicates;
import poussecafe.doc.model.DocletAccess;
import poussecafe.doc.model.processstepdoc.ConsumedMessageExtractionState;
import poussecafe.domain.Service;
import poussecafe.messaging.Message;

public class ConsumedMessageExtractor
implements Service {
    private DocletEnvironment docletEnvironment;
    private ClassDocPredicates classDocPredicates;
    private DocletAccess docletAccess;

    public Optional<String> consumedMessage(ExecutableElement methodDoc) {
        Iterator<? extends VariableElement> iterator = methodDoc.getParameters().iterator();
        if (iterator.hasNext()) {
            VariableElement parameter = iterator.next();
            Element parameterElement = this.docletEnvironment.getTypeUtils().asElement(parameter.asType());
            if (!(parameterElement instanceof TypeElement)) {
                return Optional.empty();
            }
            TypeElement parameterTypeElement = (TypeElement)parameterElement;
            if (this.classDocPredicates.documentsSubclassOf(parameterTypeElement, Message.class)) {
                return Optional.of(parameterTypeElement.getSimpleName().toString());
            }
            return this.consumedMessage(new ConsumedMessageExtractionState(parameterTypeElement));
        }
        return Optional.empty();
    }

    private Optional<String> consumedMessage(ConsumedMessageExtractionState state) {
        Element fieldElement;
        TypeElement nextTypeElement = state.nextTypeElement();
        if (state.alreadyExplored(nextTypeElement)) {
            return Optional.empty();
        }
        state.addExplored(nextTypeElement);
        for (VariableElement fieldDoc : this.docletAccess.fields(nextTypeElement)) {
            fieldElement = this.docletEnvironment.getTypeUtils().asElement(fieldDoc.asType());
            if (!(fieldElement instanceof TypeElement)) continue;
            return this.consumedMessageOfElement(state, fieldElement);
        }
        for (ExecutableElement methodDoc : this.docletAccess.methods(nextTypeElement)) {
            fieldElement = this.docletEnvironment.getTypeUtils().asElement(methodDoc.getReturnType());
            if (!(fieldElement instanceof TypeElement)) continue;
            return this.consumedMessageOfElement(state, fieldElement);
        }
        return Optional.empty();
    }

    private Optional<String> consumedMessageOfElement(ConsumedMessageExtractionState state, Element fieldElement) {
        TypeElement fieldTypeElement = (TypeElement)fieldElement;
        if (this.docletAccess.isPublic(fieldTypeElement) && this.classDocPredicates.documentsSubclassOf(fieldTypeElement, Message.class)) {
            return Optional.of(fieldTypeElement.getSimpleName().toString());
        }
        return this.consumedMessage(state.withNextTypeElement(fieldTypeElement));
    }
}

