/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.domainprocessdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.domainprocessdoc.DomainProcessGraphNodeName;
import poussecafe.doc.model.domainprocessdoc.ToStep;
import poussecafe.domain.ValueObject;

public class DomainProcessGraphNode
implements ValueObject {
    private DocumentationItem componentDoc;
    private List<ToStep> tos = new ArrayList<ToStep>();
    private String consumedEvent;
    private boolean external;

    public DocumentationItem componentDoc() {
        return this.componentDoc;
    }

    public List<ToStep> tos() {
        return Collections.unmodifiableList(this.tos);
    }

    public Optional<String> consumedEvent() {
        return Optional.ofNullable(this.consumedEvent);
    }

    public boolean external() {
        return this.external;
    }

    public DomainProcessGraphNodeName stepName() {
        return new DomainProcessGraphNodeName(this.componentDoc.name());
    }

    private DomainProcessGraphNode() {
    }

    public static class Builder {
        private DomainProcessGraphNode step = new DomainProcessGraphNode();

        public Builder componentDoc(DocumentationItem componentDoc) {
            this.step.componentDoc = componentDoc;
            return this;
        }

        public Builder to(ToStep to) {
            Objects.requireNonNull(to);
            this.step.tos.add(to);
            return this;
        }

        public Builder tos(List<ToStep> tos) {
            this.step.tos.addAll(tos);
            return this;
        }

        public Builder consumedEvent(String consumedEvent) {
            return this.consumedEvent(Optional.of(consumedEvent));
        }

        public Builder consumedEvent(Optional<String> consumedEvent) {
            this.step.consumedEvent = consumedEvent.orElse(null);
            return this;
        }

        public Builder external(boolean external) {
            this.step.external = external;
            return this;
        }

        public Builder step(DomainProcessGraphNode otherStep) {
            this.step.componentDoc = otherStep.componentDoc;
            this.step.tos.addAll(otherStep.tos);
            this.step.consumedEvent = otherStep.consumedEvent;
            this.step.external = otherStep.external;
            return this;
        }

        public DomainProcessGraphNode build() {
            Objects.requireNonNull(this.step.componentDoc);
            return this.step;
        }
    }
}

