/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.domainprocessdoc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import poussecafe.doc.doclet.ClassDocPredicates;
import poussecafe.doc.model.AnnotationsResolver;
import poussecafe.doc.model.ComponentDoc;
import poussecafe.doc.model.ComponentDocFactory;
import poussecafe.doc.model.ModuleComponentDoc;
import poussecafe.doc.model.ProcessDescription;
import poussecafe.doc.model.domainprocessdoc.DomainProcessDoc;
import poussecafe.doc.model.domainprocessdoc.DomainProcessDocId;
import poussecafe.doc.model.moduledoc.ModuleDoc;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.doc.model.moduledoc.ModuleDocRepository;
import poussecafe.domain.AggregateFactory;
import poussecafe.domain.DomainException;
import poussecafe.domain.Process;
import poussecafe.process.ExplicitDomainProcess;

public class DomainProcessDocFactory
extends AggregateFactory<DomainProcessDocId, DomainProcessDoc, DomainProcessDoc.Attributes> {
    private ClassDocPredicates classDocPredicates;
    private ComponentDocFactory componentDocFactory;
    private ModuleDocRepository moduleDocRepository;
    private AnnotationsResolver annotationsResolver;

    public DomainProcessDoc newDomainProcessDoc(ModuleDocId moduleDocId, TypeElement doc) {
        if (!this.isDomainProcessDoc(doc)) {
            throw new DomainException("Class " + doc.getQualifiedName() + " is not a domain process");
        }
        String name = this.name(doc);
        DomainProcessDocId id = new DomainProcessDocId(doc.getQualifiedName().toString());
        DomainProcessDoc domainProcessDoc = (DomainProcessDoc)this.newAggregateWithId((Object)id);
        String moduleName = ((ComponentDoc)((ModuleDoc.Attributes)((ModuleDoc)this.moduleDocRepository.get((Object)moduleDocId)).attributes()).componentDoc().value()).name();
        ((DomainProcessDoc.Attributes)domainProcessDoc.attributes()).moduleComponentDoc().value((Object)new ModuleComponentDoc.Builder().moduleDocId(moduleDocId).moduleName(moduleName).componentDoc(this.componentDocFactory.buildDoc(name, doc)).build());
        return domainProcessDoc;
    }

    public boolean isDomainProcessDoc(TypeElement doc) {
        return this.classDocPredicates.documentsWithSuperclass(doc, ExplicitDomainProcess.class) || this.classDocPredicates.documentsWithSuperinterface(doc, Process.class);
    }

    public String name(TypeElement doc) {
        return doc.getSimpleName().toString();
    }

    public List<DomainProcessDoc> createDomainProcesses(ModuleDocId moduleDocId, ExecutableElement methodDoc) {
        if (!this.isDomainProcessDoc(methodDoc)) {
            throw new DomainException("Method " + methodDoc.getSimpleName() + " does not define any domain process");
        }
        List<ProcessDescription> descriptions = this.annotationsResolver.processDescription(methodDoc);
        HashSet<String> detectedDomainProcesses = new HashSet<String>();
        ArrayList<DomainProcessDoc> processes = new ArrayList<DomainProcessDoc>();
        for (ProcessDescription description : descriptions) {
            detectedDomainProcesses.add(description.name());
            DomainProcessDoc doc = this.buildDomainProcessDoc(moduleDocId, description);
            processes.add(doc);
        }
        List<String> names = this.annotationsResolver.process(methodDoc);
        for (String name : names) {
            if (detectedDomainProcesses.contains(name)) continue;
            detectedDomainProcesses.add(name);
            DomainProcessDoc doc = this.buildDomainProcessDoc(moduleDocId, new ProcessDescription.Builder().name(name).description("").build());
            processes.add(doc);
        }
        return processes;
    }

    private DomainProcessDoc buildDomainProcessDoc(ModuleDocId moduleDocId, ProcessDescription description) {
        DomainProcessDocId id = new DomainProcessDocId(moduleDocId.stringValue() + "." + description.name());
        DomainProcessDoc doc = (DomainProcessDoc)this.newAggregateWithId((Object)id);
        String moduleName = ((ComponentDoc)((ModuleDoc.Attributes)((ModuleDoc)this.moduleDocRepository.get((Object)moduleDocId)).attributes()).componentDoc().value()).name();
        ((DomainProcessDoc.Attributes)doc.attributes()).moduleComponentDoc().value((Object)new ModuleComponentDoc.Builder().moduleDocId(moduleDocId).moduleName(moduleName).componentDoc(new ComponentDoc.Builder().name(description.name()).description(description.description()).build()).build());
        return doc;
    }

    public boolean isDomainProcessDoc(ExecutableElement doc) {
        return !this.annotationsResolver.processDescription(doc).isEmpty() || !this.annotationsResolver.process(doc).isEmpty();
    }
}

