/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.domainprocessdoc;

import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import poussecafe.domain.DomainException;

public class ComponentMethodName {
    private String componentName;
    private String methodName;

    private ComponentMethodName() {
    }

    public String componentName() {
        return this.componentName;
    }

    public String methodName() {
        return this.methodName;
    }

    public String toString() {
        return this.componentName + "." + this.methodName;
    }

    public static ComponentMethodName parse(String signatureString) {
        String[] parts = signatureString.split("\\.");
        if (parts.length != 2) {
            throw new DomainException("Wrong signature format: " + signatureString);
        }
        String aggregateName = parts[0];
        String methodName = parts[1];
        return new Builder().componentName(aggregateName).methodName(methodName).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.componentName).append((Object)this.methodName).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentMethodName other = (ComponentMethodName)obj;
        return new EqualsBuilder().append((Object)this.componentName, (Object)other.componentName).append((Object)this.methodName, (Object)other.methodName).build();
    }

    public static class Builder {
        private ComponentMethodName signature = new ComponentMethodName();

        public Builder componentName(String aggregateName) {
            this.signature.componentName = aggregateName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.signature.methodName = methodName;
            return this;
        }

        public ComponentMethodName build() {
            Objects.requireNonNull(this.signature.componentName);
            Objects.requireNonNull(this.signature.methodName);
            return this.signature;
        }
    }
}

