/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model.aggregatedoc;

import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.discovery.Aggregate;
import poussecafe.discovery.MessageListener;
import poussecafe.doc.annotations.AnnotationUtils;
import poussecafe.doc.commands.CreateAggregateDoc;
import poussecafe.doc.doclet.ClassDocPredicates;
import poussecafe.doc.doclet.Logger;
import poussecafe.doc.model.ClassDocRepository;
import poussecafe.doc.model.ComponentDoc;
import poussecafe.doc.model.ComponentDocFactory;
import poussecafe.doc.model.ModuleComponentDoc;
import poussecafe.doc.model.aggregatedoc.AggregateDoc;
import poussecafe.doc.model.aggregatedoc.AggregateDocId;
import poussecafe.doc.model.entitydoc.EntityDocFactory;
import poussecafe.doc.model.moduledoc.ModuleDoc;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.doc.model.moduledoc.ModuleDocRepository;
import poussecafe.doc.process.AggregateDocCreation;
import poussecafe.domain.AggregateFactory;
import poussecafe.domain.AggregateRepository;
import poussecafe.domain.AggregateRoot;
import poussecafe.domain.DomainException;
import poussecafe.domain.Factory;
import poussecafe.domain.Repository;
import poussecafe.source.generation.NamingConventions;

public class AggregateDocFactory
extends AggregateFactory<AggregateDocId, AggregateDoc, AggregateDoc.Attributes> {
    private ClassDocRepository classDocRepository;
    private ModuleDocRepository moduleDocRepository;
    private ComponentDocFactory componentDocFactory;
    private EntityDocFactory entityDocFactory;
    private ClassDocPredicates classDocPredicates;
    private DocletEnvironment docletEnvironment;
    private static final int FACTORY_AGGREGATE_TYPE_INDEX = 1;
    private static final int DEPRECATED_REPOSITORY_AGGREGATE_TYPE_INDEX = 0;
    private static final int REPOSITORY_AGGREGATE_TYPE_INDEX = 1;

    @MessageListener(processes={AggregateDocCreation.class})
    public AggregateDoc newAggregateDoc(CreateAggregateDoc command) {
        String className = (String)command.className().value();
        TypeElement aggregateClassDoc = this.classDocRepository.getClassDoc(className);
        if (!this.isAggregateDoc(aggregateClassDoc)) {
            throw new DomainException("Class " + aggregateClassDoc.getQualifiedName() + " is not an aggregate root");
        }
        AggregateDocId id = AggregateDocId.ofClassName(aggregateClassDoc.getQualifiedName().toString());
        AggregateDoc aggregateDoc = (AggregateDoc)this.newAggregateWithId((Object)id);
        String name = this.name(aggregateClassDoc);
        ModuleDocId moduleDocId = (ModuleDocId)((Object)command.moduleId().value());
        String moduleName = ((ComponentDoc)((ModuleDoc.Attributes)((ModuleDoc)this.moduleDocRepository.get((Object)moduleDocId)).attributes()).componentDoc().value()).name();
        ((AggregateDoc.Attributes)aggregateDoc.attributes()).moduleComponentDoc().value((Object)new ModuleComponentDoc.Builder().moduleDocId(moduleDocId).moduleName(moduleName).componentDoc(this.componentDocFactory.buildDoc(name, aggregateClassDoc)).build());
        if (this.isStandaloneRoot(aggregateClassDoc)) {
            ((AggregateDoc.Attributes)aggregateDoc.attributes()).idClassName().value((Object)this.entityDocFactory.idClassName(aggregateClassDoc));
        } else {
            String idClassName = this.innerRoot(aggregateClassDoc).map(this.entityDocFactory::idClassName).orElseThrow();
            ((AggregateDoc.Attributes)aggregateDoc.attributes()).idClassName().value((Object)idClassName);
        }
        return aggregateDoc;
    }

    private String name(TypeElement aggregateClassDoc) {
        String simpleClassName = aggregateClassDoc.getSimpleName().toString();
        if (this.isStandaloneRoot(aggregateClassDoc)) {
            try {
                return NamingConventions.aggregateNameFromSimpleRootName((String)simpleClassName);
            }
            catch (IllegalArgumentException e) {
                Logger.warn("Aggregate root not following naming conventions: {}", simpleClassName);
                return simpleClassName;
            }
        }
        return simpleClassName;
    }

    public Optional<TypeElement> innerRoot(TypeElement aggregateClassDoc) {
        for (Element element : aggregateClassDoc.getEnclosedElements()) {
            TypeElement typeElement;
            if (!(element instanceof TypeElement) || !this.extendsAggregateRoot(typeElement = (TypeElement)element)) continue;
            return Optional.of(typeElement);
        }
        return Optional.empty();
    }

    public boolean isAggregateDoc(TypeElement classDoc) {
        return this.isStandaloneRoot(classDoc) || this.isContainer(classDoc);
    }

    public boolean isStandaloneRoot(TypeElement classDoc) {
        return !this.isEnclosedType(classDoc) && this.extendsAggregateRoot(classDoc);
    }

    public boolean extendsAggregateRoot(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, AggregateRoot.class);
    }

    private boolean isEnclosedType(TypeElement classDoc) {
        return classDoc.getEnclosingElement().getKind() != ElementKind.PACKAGE;
    }

    public boolean isContainer(TypeElement classDoc) {
        Optional<AnnotationMirror> annotationMirror = AnnotationUtils.annotation(classDoc, Aggregate.class);
        return annotationMirror.isPresent();
    }

    public boolean isFactoryDoc(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, AggregateFactory.class);
    }

    public TypeElement aggregateTypeElementOfFactory(TypeElement factoryTypeElement) {
        if (!this.isFactoryDoc(factoryTypeElement)) {
            throw new IllegalArgumentException();
        }
        if (this.isEnclosedType(factoryTypeElement)) {
            return (TypeElement)factoryTypeElement.getEnclosingElement();
        }
        DeclaredType superclass = (DeclaredType)factoryTypeElement.getSuperclass();
        return (TypeElement)this.docletEnvironment.getTypeUtils().asElement(superclass.getTypeArguments().get(1));
    }

    public boolean isRepositoryDoc(TypeElement classDoc) {
        return this.isDeprecatedRepository(classDoc) || this.classDocPredicates.documentsWithSuperclass(classDoc, AggregateRepository.class);
    }

    private boolean isDeprecatedRepository(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, Repository.class);
    }

    public TypeElement aggregateTypeElementOfRepository(TypeElement repositoryTypeElement) {
        if (!this.isRepositoryDoc(repositoryTypeElement)) {
            throw new IllegalArgumentException();
        }
        if (this.isEnclosedType(repositoryTypeElement)) {
            return (TypeElement)repositoryTypeElement.getEnclosingElement();
        }
        DeclaredType superclass = (DeclaredType)repositoryTypeElement.getSuperclass();
        if (this.isDeprecatedRepository(repositoryTypeElement)) {
            return (TypeElement)this.docletEnvironment.getTypeUtils().asElement(superclass.getTypeArguments().get(0));
        }
        return (TypeElement)this.docletEnvironment.getTypeUtils().asElement(superclass.getTypeArguments().get(1));
    }

    public boolean isStandaloneFactory(TypeElement classDoc) {
        return !this.isEnclosedType(classDoc) && (this.extendsFactory(classDoc) || this.extendsDeprecatedFactory(classDoc));
    }

    private boolean extendsFactory(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, AggregateFactory.class);
    }

    private boolean extendsDeprecatedFactory(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, Factory.class);
    }

    public boolean isStandaloneRepository(TypeElement classDoc) {
        return !this.isEnclosedType(classDoc) && (this.extendsRepository(classDoc) || this.extendsDeprecatedRepository(classDoc));
    }

    public TypeElement aggregateTypeElementOfRoot(TypeElement rootTypeElement) {
        if (!this.extendsAggregateRoot(rootTypeElement)) {
            throw new IllegalArgumentException();
        }
        if (this.isEnclosedType(rootTypeElement)) {
            return (TypeElement)rootTypeElement.getEnclosingElement();
        }
        return rootTypeElement;
    }

    private boolean extendsRepository(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, AggregateRepository.class);
    }

    private boolean extendsDeprecatedRepository(TypeElement classDoc) {
        return this.classDocPredicates.documentsWithSuperclass(classDoc, Repository.class);
    }
}

