/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.Module;
import poussecafe.doc.model.UbiquitousLanguageEntry;
import poussecafe.domain.Service;

public class UbiquitousLanguageFactory
implements Service {
    public List<UbiquitousLanguageEntry> buildUbiquitousLanguage(Domain domain) {
        HashSet<UbiquitousLanguageEntry> language = new HashSet<UbiquitousLanguageEntry>();
        for (Module module : domain.modules()) {
            DocumentationItem moduleDoc = module.documentation();
            language.add(new UbiquitousLanguageEntry.Builder().componentDoc(moduleDoc).type("Module").build());
            String moduleName = moduleDoc.moduleName();
            for (Aggregate aggregate : module.aggregates()) {
                DocumentationItem aggregateDoc = aggregate.documentation();
                language.add(new UbiquitousLanguageEntry.Builder().moduleName(moduleName).componentDoc(aggregateDoc).type("Aggregate").build());
                for (DocumentationItem entityDoc : aggregate.entities()) {
                    language.add(new UbiquitousLanguageEntry.Builder().moduleName(entityDoc.moduleName()).componentDoc(entityDoc).type("Entity").build());
                }
                for (DocumentationItem valueObjectDoc : aggregate.valueObjects()) {
                    language.add(new UbiquitousLanguageEntry.Builder().moduleName(valueObjectDoc.moduleName()).componentDoc(valueObjectDoc).type("Value Object").build());
                }
            }
            for (DocumentationItem serviceDoc : module.services()) {
                language.add(new UbiquitousLanguageEntry.Builder().moduleName(serviceDoc.moduleName()).componentDoc(serviceDoc).type("Service").build());
            }
            for (DocumentationItem domainProcessDoc : module.processes()) {
                language.add(new UbiquitousLanguageEntry.Builder().moduleName(domainProcessDoc.moduleName()).componentDoc(domainProcessDoc).type("Domain Process").build());
            }
        }
        return language.stream().sorted().collect(Collectors.toList());
    }
}

