/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import poussecafe.util.Equality;

public class ProcessDescription {
    private String name;
    private String description;

    public static ProcessDescription parse(String text) {
        ProcessDescription description = new ProcessDescription();
        String[] words = text.split("\\s+", 2);
        description.name(words[0]);
        description.description(words[1]);
        return description;
    }

    private ProcessDescription() {
    }

    private void name(String name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    private void description(String description) {
        Objects.requireNonNull(description);
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public boolean equals(Object obj) {
        return Equality.referenceEquals((Object)this, (Object)obj).orElse(other -> new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.description, (Object)other.description).build());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.description).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).append((Object)this.description).build();
    }

    public static class Builder {
        private ProcessDescription description = new ProcessDescription();

        public Builder name(String name) {
            this.description.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description.description = description;
            return this;
        }

        public ProcessDescription build() {
            Objects.requireNonNull(this.description.name);
            Objects.requireNonNull(this.description.description);
            return this.description;
        }
    }
}

