/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.Objects;
import poussecafe.doc.model.ComponentDoc;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.domain.ValueObject;

public class ModuleComponentDoc
implements ValueObject {
    private ComponentDoc componentDoc;
    private ModuleDocId moduleDocId;
    private String moduleName;

    private ModuleComponentDoc() {
    }

    public ComponentDoc componentDoc() {
        return this.componentDoc;
    }

    public ModuleDocId moduleDocId() {
        return this.moduleDocId;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public DocumentationItem.Builder toDocumentationItem() {
        return this.componentDoc.documentationItemBuilder().moduleName(this.moduleName);
    }

    public static class Builder {
        private ModuleComponentDoc doc = new ModuleComponentDoc();

        public Builder componentDoc(ComponentDoc componentDoc) {
            this.doc.componentDoc = componentDoc;
            return this;
        }

        public Builder moduleDocId(ModuleDocId moduleDocId) {
            this.doc.moduleDocId = moduleDocId;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.doc.moduleName = moduleName;
            return this;
        }

        public ModuleComponentDoc build() {
            Objects.requireNonNull(this.doc.componentDoc);
            Objects.requireNonNull(this.doc.moduleDocId);
            Objects.requireNonNull(this.doc.moduleName);
            return this.doc;
        }
    }
}

