/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import poussecafe.discovery.DefaultProcess;
import poussecafe.doc.StringNormalizer;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.MessageListener;
import poussecafe.domain.ValueObject;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.model.Documentation;

public class Module
implements ValueObject {
    private DocumentationItem documentation;
    private List<Aggregate> aggregates;
    private List<DocumentationItem> services;
    private List<DocumentationItem> processes;
    private List<MessageListener> listeners = new ArrayList<MessageListener>();

    public DocumentationItem documentation() {
        return this.documentation;
    }

    public List<Aggregate> aggregates() {
        return this.aggregates;
    }

    public Optional<Aggregate> aggregate(String name) {
        return this.aggregates().stream().filter(item -> item.documentation().name().equals(name)).findFirst();
    }

    public List<DocumentationItem> services() {
        return this.services;
    }

    public List<DocumentationItem> processes() {
        return this.processes;
    }

    public boolean isEmpty() {
        return this.aggregates.isEmpty() && this.services.isEmpty() && this.processes.isEmpty();
    }

    public List<MessageListener> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public List<MessageListener> listeners(String processName) {
        return this.listeners.stream().filter(item -> item.processNames().contains(processName)).collect(Collectors.toList());
    }

    private Module() {
    }

    public static class Builder {
        private Module module = new Module();

        public Builder documentation(DocumentationItem documentation) {
            this.module.documentation = documentation;
            return this;
        }

        public Builder aggregates(List<Aggregate> aggregates) {
            this.module.aggregates = new ArrayList<Aggregate>(aggregates);
            return this;
        }

        public Builder services(List<DocumentationItem> services) {
            this.module.services = new ArrayList<DocumentationItem>(services);
            return this;
        }

        public Builder processes(List<DocumentationItem> processes) {
            this.module.processes = new ArrayList<DocumentationItem>(processes);
            return this;
        }

        public Builder listeners(List<MessageListener> listeners) {
            this.module.listeners.addAll(listeners);
            return this;
        }

        public Module build() {
            Objects.requireNonNull(this.module.documentation);
            Objects.requireNonNull(this.module.aggregates);
            Objects.requireNonNull(this.module.services);
            Objects.requireNonNull(this.module.processes);
            if (this.module.listeners.stream().anyMatch(listener -> listener.processNames().contains(DefaultProcess.class.getSimpleName()))) {
                this.module.processes.add(new DocumentationItem.Builder().id(StringNormalizer.normalizeString(DefaultProcess.class.getSimpleName())).className(Optional.of(new ClassName(DefaultProcess.class.getCanonicalName()))).description(new Documentation.Builder().description("The default process includes all listeners with no explicit process defined. One may explictly link a listener to the default process but this is not recommended.").shortDescription("The default process includes all listeners with no explicit process defined").build()).moduleName(this.module.documentation.moduleName()).name(DefaultProcess.class.getSimpleName()).build());
            }
            return this.module;
        }
    }
}

