/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import poussecafe.doc.model.domainprocessdoc.DomainProcessGraphNode;
import poussecafe.doc.model.domainprocessdoc.DomainProcessGraphNodeName;
import poussecafe.doc.model.domainprocessdoc.ToStep;

public class DomainProcessGraphNodes {
    private Map<DomainProcessGraphNodeName, DomainProcessGraphNode> nodes;
    private List<DomainProcessGraphNode> orderedSteps;

    public Map<DomainProcessGraphNodeName, DomainProcessGraphNode> steps() {
        return this.nodes;
    }

    public List<DomainProcessGraphNode> orderedSteps() {
        if (this.orderedSteps == null) {
            Map<String, List<String>> graph = this.buildGraphMap();
            List<String> orderedStepNames = this.topologicalOrdering(graph);
            this.orderedSteps = orderedStepNames.stream().map(DomainProcessGraphNodeName::new).map(stepName -> this.nodes.get(stepName)).collect(Collectors.toList());
        }
        return this.orderedSteps;
    }

    private Map<String, List<String>> buildGraphMap() {
        HashMap<String, List<String>> graph = new HashMap<String, List<String>>();
        for (DomainProcessGraphNode step : this.nodes.values()) {
            if (!graph.containsKey(step.componentDoc().name())) {
                graph.put(step.componentDoc().name(), new ArrayList());
            }
            for (ToStep to : step.tos()) {
                ArrayList<String> froms = (ArrayList<String>)graph.get(to.name().stringValue());
                if (froms == null) {
                    froms = new ArrayList<String>();
                    graph.put(to.name().stringValue(), froms);
                }
                froms.add(step.componentDoc().name());
            }
        }
        return graph;
    }

    private List<String> topologicalOrdering(Map<String, List<String>> graph) {
        ArrayList<String> orderedNodes = new ArrayList<String>();
        HashMap<String, List<String>> partialGraph = new HashMap<String, List<String>>(graph);
        while (partialGraph.size() > 0) {
            String nodeWithoutFrom = this.findNodeWithoutFrom(partialGraph);
            orderedNodes.add(nodeWithoutFrom);
            this.removeNode(partialGraph, nodeWithoutFrom);
        }
        return orderedNodes;
    }

    private String findNodeWithoutFrom(Map<String, List<String>> graph) {
        for (Map.Entry<String, List<String>> e : graph.entrySet()) {
            if (!e.getValue().isEmpty()) continue;
            return e.getKey();
        }
        return graph.entrySet().iterator().next().getKey();
    }

    private void removeNode(Map<String, List<String>> graph, String nodeName) {
        Iterator<Map.Entry<String, List<String>>> iterator = graph.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            if (entry.getKey().equals(nodeName)) {
                iterator.remove();
                continue;
            }
            entry.getValue().remove(nodeName);
        }
    }

    public DomainProcessGraphNode getStep(DomainProcessGraphNodeName name) {
        return this.nodes.get((Object)name);
    }

    private DomainProcessGraphNodes(Map<DomainProcessGraphNodeName, DomainProcessGraphNode> steps) {
        Objects.requireNonNull(steps);
        this.nodes = steps;
    }

    public static class Builder {
        private Map<DomainProcessGraphNodeName, DomainProcessGraphNode> steps = new HashMap<DomainProcessGraphNodeName, DomainProcessGraphNode>();

        public Builder merge(Map<DomainProcessGraphNodeName, DomainProcessGraphNode> stepsToBeMerged) {
            for (Map.Entry<DomainProcessGraphNodeName, DomainProcessGraphNode> entry : stepsToBeMerged.entrySet()) {
                DomainProcessGraphNode existingStep = this.steps.get((Object)entry.getKey());
                if (existingStep == null) {
                    this.steps.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.steps.put(entry.getKey(), new DomainProcessGraphNode.Builder().step(existingStep).tos(entry.getValue().tos()).build());
            }
            return this;
        }

        public Builder add(DomainProcessGraphNode step) {
            this.steps.put(step.stepName(), step);
            return this;
        }

        public DomainProcessGraphNode getStep(DomainProcessGraphNodeName stepName) {
            return this.steps.get((Object)stepName);
        }

        public DomainProcessGraphNodes build() {
            return new DomainProcessGraphNodes(this.steps);
        }
    }
}

