/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import poussecafe.doc.doclet.PousseCafeDocletConfiguration;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.MessageListener;
import poussecafe.doc.model.Module;
import poussecafe.doc.model.Relation;
import poussecafe.doc.model.aggregatedoc.AggregateDoc;
import poussecafe.doc.model.aggregatedoc.AggregateDocRepository;
import poussecafe.doc.model.domainprocessdoc.DomainProcessDoc;
import poussecafe.doc.model.domainprocessdoc.DomainProcessDocRepository;
import poussecafe.doc.model.entitydoc.EntityDoc;
import poussecafe.doc.model.entitydoc.EntityDocId;
import poussecafe.doc.model.entitydoc.EntityDocRepository;
import poussecafe.doc.model.moduledoc.ModuleDoc;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.doc.model.moduledoc.ModuleDocRepository;
import poussecafe.doc.model.processstepdoc.ProcessStepDoc;
import poussecafe.doc.model.processstepdoc.ProcessStepDocRepository;
import poussecafe.doc.model.relationdoc.ComponentType;
import poussecafe.doc.model.relationdoc.RelationDoc;
import poussecafe.doc.model.relationdoc.RelationDocRepository;
import poussecafe.doc.model.servicedoc.ServiceDoc;
import poussecafe.doc.model.servicedoc.ServiceDocRepository;
import poussecafe.doc.model.vodoc.ValueObjectDoc;
import poussecafe.doc.model.vodoc.ValueObjectDocId;
import poussecafe.doc.model.vodoc.ValueObjectDocRepository;
import poussecafe.domain.Service;
import poussecafe.source.analysis.ClassName;

public class DomainFactory
implements Service {
    private PousseCafeDocletConfiguration configuration;
    private ModuleDocRepository moduleDocRepository;
    private AggregateDocRepository aggregateDocRepository;
    private RelationDocRepository relationRepository;
    private EntityDocRepository entityDocRepository;
    private ValueObjectDocRepository valueObjectDocRepository;
    private ServiceDocRepository serviceDocRepository;
    private DomainProcessDocRepository domainProcessDocRepository;
    private ProcessStepDocRepository processStepDocRepository;
    private RelationDocRepository relationDocRepository;

    public Domain buildDomain() {
        return new Domain.Builder().name(this.configuration.generationConfiguration().domainName()).version(this.configuration.generationConfiguration().version()).modules(this.modules()).relations(this.relations()).build();
    }

    private List<Module> modules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (ModuleDoc moduleDoc : this.moduleDocRepository.findAll()) {
            modules.add(this.module(moduleDoc));
        }
        return modules;
    }

    private Module module(ModuleDoc moduleDoc) {
        return new Module.Builder().documentation(moduleDoc.toDocumentationItem()).aggregates(this.aggregates(moduleDoc)).services(this.services(moduleDoc).stream().map(ServiceDoc::toDocumentationItem).collect(Collectors.toList())).processes(this.processes(moduleDoc)).listeners(this.listeners(moduleDoc)).build();
    }

    private List<Aggregate> aggregates(ModuleDoc moduleDoc) {
        ArrayList<Aggregate> aggregates = new ArrayList<Aggregate>();
        for (AggregateDoc aggregateDoc : this.aggregateDocRepository.findByModule((ModuleDocId)((Object)((ModuleDoc.Attributes)moduleDoc.attributes()).identifier().value()))) {
            aggregates.add(this.aggregate(aggregateDoc));
        }
        return aggregates;
    }

    private Aggregate aggregate(AggregateDoc aggregateDoc) {
        return new Aggregate.Builder().documentation(aggregateDoc.toDocumentationItem()).entities(this.entities(aggregateDoc)).valueObjects(this.valueObjects(aggregateDoc)).build();
    }

    private List<DocumentationItem> entities(AggregateDoc aggregateDoc) {
        return this.findEntities(aggregateDoc.className()).stream().map(arg_0 -> ((EntityDocRepository)this.entityDocRepository).getOptional(arg_0)).filter(Optional::isPresent).map(Optional::get).map(EntityDoc::toDocumentationItem).collect(Collectors.toList());
    }

    private Set<EntityDocId> findEntities(ClassName fromClassName) {
        return this.findEntities(fromClassName, new HashSet<ClassName>());
    }

    private Set<EntityDocId> findEntities(ClassName fromClassName, Set<ClassName> exploredClasses) {
        HashSet<EntityDocId> ids = new HashSet<EntityDocId>();
        if (!exploredClasses.contains(fromClassName)) {
            exploredClasses.add(fromClassName);
            for (RelationDoc relation : this.relationRepository.findWithFromClassName(fromClassName)) {
                if (relation.toComponent().type() == ComponentType.ENTITY) {
                    ids.add(EntityDocId.ofClassName(relation.toComponent().className().toString()));
                }
                if (relation.toComponent().type() == ComponentType.AGGREGATE) continue;
                ids.addAll(this.findEntities(relation.toComponent().className(), exploredClasses));
            }
        }
        return ids;
    }

    private List<DocumentationItem> valueObjects(AggregateDoc aggregateDoc) {
        return this.findValueObjects(aggregateDoc.className()).stream().map(arg_0 -> ((ValueObjectDocRepository)this.valueObjectDocRepository).getOptional(arg_0)).filter(Optional::isPresent).map(Optional::get).map(ValueObjectDoc::toDocumentationItem).collect(Collectors.toList());
    }

    private Set<ValueObjectDocId> findValueObjects(ClassName fromClassName) {
        return this.findValueObjects(fromClassName, new HashSet<ClassName>());
    }

    private Set<ValueObjectDocId> findValueObjects(ClassName fromClassName, Set<ClassName> exploredClassNames) {
        HashSet<ValueObjectDocId> ids = new HashSet<ValueObjectDocId>();
        if (!exploredClassNames.contains(fromClassName)) {
            exploredClassNames.add(fromClassName);
            for (RelationDoc relation : this.relationRepository.findWithFromClassName(fromClassName)) {
                if (relation.toComponent().type() == ComponentType.VALUE_OBJECT) {
                    ids.add(ValueObjectDocId.ofClassName(relation.toComponent().className().toString()));
                }
                if (relation.toComponent().type() == ComponentType.AGGREGATE) continue;
                ids.addAll(this.findValueObjects(relation.toComponent().className(), exploredClassNames));
            }
        }
        return ids;
    }

    private List<ServiceDoc> services(ModuleDoc moduleDoc) {
        return this.serviceDocRepository.findByModuleId((ModuleDocId)((Object)((ModuleDoc.Attributes)moduleDoc.attributes()).identifier().value()));
    }

    private List<DocumentationItem> processes(ModuleDoc moduleDoc) {
        return this.domainProcessDocRepository.findByModuleId((ModuleDocId)((Object)((ModuleDoc.Attributes)moduleDoc.attributes()).identifier().value())).stream().map(DomainProcessDoc::toDocumentationItem).collect(Collectors.toList());
    }

    private List<MessageListener> listeners(ModuleDoc moduleDoc) {
        return this.processStepDocRepository.findByModule((ModuleDocId)((Object)((ModuleDoc.Attributes)moduleDoc.attributes()).identifier().value())).stream().map(ProcessStepDoc::toMessageListener).collect(Collectors.toList());
    }

    private List<Relation> relations() {
        return this.relationDocRepository.findAll().stream().map(RelationDoc::toRelation).collect(Collectors.toList());
    }
}

