/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.Objects;
import java.util.Optional;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.model.Documentation;

public class DocumentationItem {
    private String id;
    private ClassName className;
    private String name;
    private Documentation description;
    private String moduleName;

    public String id() {
        return this.id;
    }

    public Optional<ClassName> className() {
        return Optional.ofNullable(this.className);
    }

    public String name() {
        return this.name;
    }

    public Documentation description() {
        return this.description;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public String shortDescriptionOrDefault() {
        return this.description.shortDescription().or(() -> ((Documentation)this.description).description()).map(string -> string.replaceAll("<[a-z\\/]+>", "")).orElse("");
    }

    private DocumentationItem() {
    }

    public static class Builder {
        private DocumentationItem item = new DocumentationItem();

        public DocumentationItem build() {
            Objects.requireNonNull(this.item.id);
            Objects.requireNonNull(this.item.name);
            Objects.requireNonNull(this.item.description);
            return this.item;
        }

        public Builder id(String id) {
            this.item.id = id;
            return this;
        }

        public Builder className(Optional<ClassName> className) {
            this.item.className = className.orElse(null);
            return this;
        }

        public Builder name(String name) {
            this.item.name = name;
            return this;
        }

        public Builder description(Documentation description) {
            this.item.description = description;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.item.moduleName = moduleName;
            return this;
        }
    }
}

