/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import poussecafe.doc.annotations.AnnotationUtils;
import poussecafe.doc.model.AnnotationsResolver;
import poussecafe.doc.model.ComponentDoc;
import poussecafe.domain.Service;
import poussecafe.source.ShortDescription;
import poussecafe.source.Trivial;

public class ComponentDocFactory
implements Service {
    private AnnotationsResolver annotationsResolver;

    public ComponentDoc buildDoc(String name, Element doc) {
        return new ComponentDoc.Builder().name(name).description(this.annotationsResolver.renderCommentBody(doc)).shortDescription(this.shortDescription(doc)).trivial(this.annotationsResolver.isTrivial(doc) || AnnotationUtils.annotation(doc, Trivial.class).isPresent()).build();
    }

    private Optional<String> shortDescription(Element doc) {
        Optional<AnnotationMirror> shortAnnotation = AnnotationUtils.annotation(doc, ShortDescription.class);
        if (shortAnnotation.isPresent()) {
            return Optional.of((String)AnnotationUtils.value(shortAnnotation.orElseThrow(), "value").orElseThrow().getValue());
        }
        return this.annotationsResolver.shortDescription(doc);
    }
}

