/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.model;

import java.util.Objects;
import java.util.Optional;
import poussecafe.doc.model.DocumentationItem;
import poussecafe.domain.ValueObject;
import poussecafe.source.model.Documentation;

public class ComponentDoc
implements ValueObject {
    private String name;
    private String description;
    private Optional<String> shortDescription = Optional.empty();
    private boolean trivial;

    private ComponentDoc() {
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Optional<String> shortDescription() {
        return this.shortDescription;
    }

    public boolean trivial() {
        return this.trivial;
    }

    public boolean hasDescription() {
        return !this.description.isEmpty();
    }

    public String shortDescriptionOrDefault() {
        if (this.shortDescription.isPresent()) {
            return this.shortDescription.get();
        }
        return this.description.replaceAll("<[a-z\\/]+>", "");
    }

    public DocumentationItem.Builder documentationItemBuilder() {
        return new DocumentationItem.Builder().name(this.name).description(new Documentation.Builder().description(this.description).shortDescription((String)this.shortDescription.orElse(null)).trivial(this.trivial).build());
    }

    public static class Builder {
        private ComponentDoc doc = new ComponentDoc();

        public Builder name(String name) {
            this.doc.name = name;
            return this;
        }

        public Builder description(String description) {
            this.doc.description = description;
            return this;
        }

        public Builder shortDescription(Optional<String> shortDescription) {
            this.doc.shortDescription = shortDescription;
            return this;
        }

        public Builder trivial(boolean trivial) {
            this.doc.trivial = trivial;
            return this;
        }

        public ComponentDoc build() {
            Objects.requireNonNull(this.doc.name);
            Objects.requireNonNull(this.doc.description);
            Objects.requireNonNull(this.doc.shortDescription);
            return this.doc;
        }
    }
}

