/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.Optional;
import java.util.function.Consumer;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.doc.doclet.CodeExplorer;
import poussecafe.doc.doclet.PousseCafeDocletConfiguration;
import poussecafe.doc.model.DocletServices;
import poussecafe.doc.model.ModuleComponentDoc;
import poussecafe.doc.model.aggregatedoc.AggregateDoc;
import poussecafe.doc.model.aggregatedoc.AggregateDocFactory;
import poussecafe.doc.model.aggregatedoc.AggregateDocId;
import poussecafe.doc.model.aggregatedoc.AggregateDocRepository;
import poussecafe.doc.model.entitydoc.EntityDoc;
import poussecafe.doc.model.entitydoc.EntityDocFactory;
import poussecafe.doc.model.entitydoc.EntityDocId;
import poussecafe.doc.model.entitydoc.EntityDocRepository;
import poussecafe.doc.model.relationdoc.Component;
import poussecafe.doc.model.relationdoc.ComponentType;
import poussecafe.doc.model.relationdoc.RelationDocFactory;
import poussecafe.doc.model.vodoc.ValueObjectDoc;
import poussecafe.doc.model.vodoc.ValueObjectDocFactory;
import poussecafe.doc.model.vodoc.ValueObjectDocId;
import poussecafe.doc.model.vodoc.ValueObjectDocRepository;
import poussecafe.doc.process.ComponentLinking;

public class RelationCreator
implements Consumer<TypeElement> {
    private AggregateDocFactory aggregateDocFactory;
    private EntityDocFactory entityDocFactory;
    private ValueObjectDocFactory valueObjectDocFactory;
    private PousseCafeDocletConfiguration configuration;
    private DocletServices docletServices;
    private AggregateDocRepository aggregateDocRepository;
    private ValueObjectDocRepository valueObjectDocRepository;
    private EntityDocRepository entityDocRepository;
    private ComponentLinking componentLinking;
    private DocletEnvironment docletEnvironment;

    @Override
    public void accept(TypeElement classDoc) {
        if (this.aggregateDocFactory.isAggregateDoc(classDoc)) {
            this.tryRelationAggregateId(classDoc);
        }
        if (this.entityDocFactory.isEntityDoc(classDoc)) {
            this.tryRelationEntityId(classDoc);
        }
        if (this.aggregateDocFactory.isAggregateDoc(classDoc) || this.entityDocFactory.isEntityDoc(classDoc)) {
            this.tryAttributes(classDoc);
        }
        if (this.valueObjectDocFactory.isValueObjectDoc(classDoc)) {
            CodeExplorer codeExplorer = new CodeExplorer.Builder().basePackage(this.configuration.basePackage()).rootClassDoc(classDoc).classRelationBuilder(this::classRelationBuilder).docletServices(this.docletServices).build();
            codeExplorer.explore();
        }
    }

    private void tryRelationAggregateId(TypeElement classDoc) {
        Optional idDoc;
        Optional aggregateDoc = this.aggregateDocRepository.getOptional((Object)AggregateDocId.ofClassName(classDoc.getQualifiedName().toString()));
        if (aggregateDoc.isPresent() && (idDoc = this.valueObjectDocRepository.getOptional((Object)ValueObjectDocId.ofClassName((String)((AggregateDoc.Attributes)((AggregateDoc)((Object)aggregateDoc.get())).attributes()).idClassName().value()))).isPresent()) {
            RelationDocFactory.NewRelationParameters aggregateIdParameters = new RelationDocFactory.NewRelationParameters();
            aggregateIdParameters.fromComponent = this.component(classDoc);
            aggregateIdParameters.toComponent = new Component(ComponentType.VALUE_OBJECT, ((ValueObjectDoc)((Object)idDoc.get())).className(), ((ModuleComponentDoc)((ValueObjectDoc.Attributes)((ValueObjectDoc)((Object)idDoc.get())).attributes()).moduleComponentDoc().value()).componentDoc().name());
            this.componentLinking.linkComponents(aggregateIdParameters);
            RelationDocFactory.NewRelationParameters idAggregateParameters = new RelationDocFactory.NewRelationParameters();
            idAggregateParameters.fromComponent = aggregateIdParameters.toComponent;
            idAggregateParameters.toComponent = aggregateIdParameters.fromComponent;
            this.componentLinking.linkComponents(idAggregateParameters);
        }
    }

    private void tryRelationEntityId(TypeElement classDoc) {
        Optional idDoc;
        Optional entityDoc = this.entityDocRepository.getOptional((Object)EntityDocId.ofClassName(classDoc.getQualifiedName().toString()));
        if (entityDoc.isPresent() && (idDoc = this.valueObjectDocRepository.getOptional((Object)ValueObjectDocId.ofClassName((String)((EntityDoc.Attributes)((EntityDoc)((Object)entityDoc.get())).attributes()).idClassName().value()))).isPresent()) {
            RelationDocFactory.NewRelationParameters entityIdParameters = new RelationDocFactory.NewRelationParameters();
            entityIdParameters.fromComponent = this.component(classDoc);
            entityIdParameters.toComponent = new Component(ComponentType.VALUE_OBJECT, ((ValueObjectDoc)((Object)idDoc.get())).className(), ((ModuleComponentDoc)((ValueObjectDoc.Attributes)((ValueObjectDoc)((Object)idDoc.orElseThrow())).attributes()).moduleComponentDoc().value()).componentDoc().name());
            this.componentLinking.linkComponents(entityIdParameters);
        }
    }

    private Component component(TypeElement classDoc) {
        String className = classDoc.getQualifiedName().toString();
        if (this.aggregateDocFactory.isAggregateDoc(classDoc)) {
            AggregateDoc aggregate = (AggregateDoc)this.aggregateDocRepository.get((Object)AggregateDocId.ofClassName(className));
            return new Component(ComponentType.AGGREGATE, aggregate.className(), ((ModuleComponentDoc)((AggregateDoc.Attributes)aggregate.attributes()).moduleComponentDoc().value()).componentDoc().name());
        }
        if (this.entityDocFactory.isEntityDoc(classDoc)) {
            EntityDoc entity = (EntityDoc)this.entityDocRepository.get((Object)EntityDocId.ofClassName(className));
            return new Component(ComponentType.ENTITY, entity.className(), ((ModuleComponentDoc)((EntityDoc.Attributes)entity.attributes()).moduleComponentDoc().value()).componentDoc().name());
        }
        if (this.valueObjectDocFactory.isValueObjectDoc(classDoc)) {
            ValueObjectDoc valueObject = (ValueObjectDoc)this.valueObjectDocRepository.get((Object)ValueObjectDocId.ofClassName(className));
            return new Component(ComponentType.VALUE_OBJECT, valueObject.className(), ((ModuleComponentDoc)((ValueObjectDoc.Attributes)valueObject.attributes()).moduleComponentDoc().value()).componentDoc().name());
        }
        throw new IllegalArgumentException("Unsupported component class " + classDoc.getQualifiedName().toString());
    }

    private void classRelationBuilder(TypeElement from, TypeElement to) {
        if (from != to) {
            this.linkComponents(from, to);
        }
    }

    private void linkComponents(TypeElement from, TypeElement to) {
        RelationDocFactory.NewRelationParameters parameters = new RelationDocFactory.NewRelationParameters();
        parameters.fromComponent = this.component(from);
        parameters.toComponent = this.component(to);
        this.componentLinking.linkComponents(parameters);
    }

    private void tryAttributes(TypeElement classDoc) {
        TypeElement rootClassDoc = this.aggregateDocFactory.isStandaloneRoot(classDoc) || this.entityDocFactory.isEntityDoc(classDoc) ? classDoc : this.aggregateDocFactory.innerRoot(classDoc).orElseThrow();
        DeclaredType superclass = (DeclaredType)rootClassDoc.getSuperclass();
        TypeElement attributesClassDoc = (TypeElement)this.docletEnvironment.getTypeUtils().asElement(superclass.getTypeArguments().get(1));
        CodeExplorer pathFinder = new CodeExplorer.Builder().rootClassDoc(classDoc).basePackage(this.configuration.basePackage()).classRelationBuilder(this::classRelationBuilder).docletServices(this.docletServices).build();
        pathFinder.explore(attributesClassDoc);
    }
}

