/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import poussecafe.collection.Collections;
import poussecafe.doc.PousseCafeDocGenerationConfiguration;
import poussecafe.doc.doclet.PousseCafeDoclet;
import poussecafe.doc.doclet.PousseCafeDocletConfiguration;
import poussecafe.doc.doclet.SystemDependentInformation;

public class PousseCafeDocletExecutor {
    private PousseCafeDocletConfiguration configuration;

    public PousseCafeDocletExecutor(PousseCafeDocletConfiguration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
    }

    public void execute() {
        ArrayList<String> javadocArgs = new ArrayList<String>();
        this.addStandardOptionsTo(javadocArgs);
        this.addDocletOptionsTo(javadocArgs);
        DocumentationTool documentationTool = ToolProvider.getSystemDocumentationTool();
        StandardJavaFileManager fileManager = documentationTool.getStandardFileManager(null, null, null);
        try {
            Iterable<JavaFileObject> compilationUnits = fileManager.list(StandardLocation.SOURCE_PATH, this.configuration.basePackage(), Collections.asSet((Object[])new JavaFileObject.Kind[]{JavaFileObject.Kind.SOURCE}), true);
            DocumentationTool.DocumentationTask task = documentationTool.getTask(this.configuration.errorWriter(), fileManager, null, PousseCafeDoclet.class, javadocArgs, compilationUnits);
            task.call();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to generate documentation", e);
        }
    }

    private void addStandardOptionsTo(List<String> javadocArgs) {
        String pathElementSeparator = SystemDependentInformation.pathElementSeparator();
        javadocArgs.add("-sourcepath");
        javadocArgs.add(this.configuration.sourcePath().stream().collect(Collectors.joining(pathElementSeparator)));
        javadocArgs.add("-subpackages");
        javadocArgs.add(this.configuration.basePackage());
        if (!this.configuration.classPath().isEmpty()) {
            javadocArgs.add("-classpath");
            javadocArgs.add(this.configuration.classPath().stream().collect(Collectors.joining(pathElementSeparator)));
        }
    }

    private void addDocletOptionsTo(List<String> javadocArgs) {
        Optional<String> customFdpExecutable;
        Optional<String> customDotExecutable;
        PousseCafeDocGenerationConfiguration generationConfiguration = this.configuration.generationConfiguration();
        javadocArgs.add("-output");
        javadocArgs.add(generationConfiguration.outputDirectory());
        javadocArgs.add("-pdfFile");
        javadocArgs.add(generationConfiguration.pdfFileName());
        javadocArgs.add("-domain");
        javadocArgs.add(generationConfiguration.domainName());
        javadocArgs.add("-version");
        javadocArgs.add(generationConfiguration.version());
        javadocArgs.add("-basePackage");
        javadocArgs.add(this.configuration.basePackage());
        if (generationConfiguration.includeGenerationDate()) {
            javadocArgs.add("-includeGeneratedDate");
        }
        if ((customDotExecutable = generationConfiguration.customDotExecutable()).isPresent()) {
            javadocArgs.add("-customDotExecutable");
            javadocArgs.add(customDotExecutable.orElseThrow());
        }
        if ((customFdpExecutable = generationConfiguration.customFdpExecutable()).isPresent()) {
            javadocArgs.add("-customFdpExecutable");
            javadocArgs.add(customFdpExecutable.orElseThrow());
        }
    }
}

