/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import poussecafe.doc.GraphImagesWriter;
import poussecafe.doc.HtmlWriter;
import poussecafe.doc.PdfWriter;
import poussecafe.doc.PousseCafeDocBundle;
import poussecafe.doc.PousseCafeDocGenerationConfiguration;
import poussecafe.doc.doclet.AggregateDocCreator;
import poussecafe.doc.doclet.ClassModuleDocCreator;
import poussecafe.doc.doclet.ClassesAnalyzer;
import poussecafe.doc.doclet.DomainProcessDocCreator;
import poussecafe.doc.doclet.EntityDocCreator;
import poussecafe.doc.doclet.Logger;
import poussecafe.doc.doclet.PackageInfoModuleDocCreator;
import poussecafe.doc.doclet.PackagesAnalyzer;
import poussecafe.doc.doclet.PousseCafeDocletConfiguration;
import poussecafe.doc.doclet.ProcessStepDocCreator;
import poussecafe.doc.doclet.RelationCreator;
import poussecafe.doc.doclet.ServiceDocCreator;
import poussecafe.doc.doclet.ValueObjectDocCreator;
import poussecafe.doc.doclet.options.BasePackageOption;
import poussecafe.doc.doclet.options.CustomDotExecutableOption;
import poussecafe.doc.doclet.options.CustomFdpExecutableOption;
import poussecafe.doc.doclet.options.DomainOption;
import poussecafe.doc.doclet.options.IncludeGeneratedDateOption;
import poussecafe.doc.doclet.options.OutputPathOption;
import poussecafe.doc.doclet.options.PdfFileNameOption;
import poussecafe.doc.doclet.options.SourcePathOption;
import poussecafe.doc.doclet.options.VersionOption;
import poussecafe.doc.model.ClassDocRepository;
import poussecafe.doc.model.DocletAccess;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.DomainFactory;
import poussecafe.exception.PousseCafeException;
import poussecafe.runtime.Runtime;

public class PousseCafeDoclet
implements Doclet {
    private PousseCafeDocletConfiguration.BaseBuilder docletConfigBuilder = PousseCafeDocletConfiguration.builder();
    private PousseCafeDocGenerationConfiguration.Builder generatorConfigBuilder = PousseCafeDocGenerationConfiguration.builder();
    private Runtime runtime;
    private DocletEnvironment environment;
    private PousseCafeDocletConfiguration configuration;

    @Override
    public void init(Locale locale, Reporter reporter) {
        Logger.setRootDoc(reporter);
    }

    @Override
    public String getName() {
        return "DDD Documentation";
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        HashSet<Doclet.Option> supportedOptions = new HashSet<Doclet.Option>();
        supportedOptions.add(new DomainOption(this.generatorConfigBuilder));
        supportedOptions.add(new IncludeGeneratedDateOption(this.generatorConfigBuilder));
        supportedOptions.add(new OutputPathOption(this.generatorConfigBuilder));
        supportedOptions.add(new VersionOption(this.generatorConfigBuilder));
        supportedOptions.add(new CustomDotExecutableOption(this.generatorConfigBuilder));
        supportedOptions.add(new CustomFdpExecutableOption(this.generatorConfigBuilder));
        supportedOptions.add(new PdfFileNameOption(this.generatorConfigBuilder));
        supportedOptions.add(new BasePackageOption(this.docletConfigBuilder));
        supportedOptions.add(new SourcePathOption(this.docletConfigBuilder));
        return supportedOptions;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_9;
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        this.environment = environment;
        this.docletConfigBuilder.generationConfiguration(this.generatorConfigBuilder.build());
        this.configuration = this.docletConfigBuilder.build();
        this.runtime = new Runtime.Builder().withBundle(PousseCafeDocBundle.configure().defineAndImplementDefault().build()).withInjectableService(DocletEnvironment.class, (Object)environment).withInjectableService((Object)this.configuration).build();
        Logger.info("Starting Pousse-Caf\u00e9 doclet...", new Object[0]);
        try {
            this.runtime.start();
            this.registerClassDocs();
            this.analyzeCode();
            this.createOutputFolder();
            Domain domain = ((DomainFactory)this.runtime.environment().service(DomainFactory.class).orElseThrow()).buildDomain();
            this.writeGraphs(domain);
            this.writeHtml(domain);
            this.writePdf();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void registerClassDocs() {
        Set<TypeElement> typeElements = ((DocletAccess)this.runtime.environment().service(DocletAccess.class).orElseThrow(NoSuchElementException::new)).typeElements();
        ((ClassDocRepository)this.runtime.environment().service(ClassDocRepository.class).orElseThrow(PousseCafeException::new)).registerTypeElements(typeElements);
    }

    private void analyzeCode() {
        this.detectModules();
        this.detectModulesComponents();
        this.detectDomainProcesses();
        this.detectRelations();
    }

    private void detectModules() {
        this.detectClassBasedModules();
        this.detectPackageInfoModules();
    }

    private void detectClassBasedModules() {
        ClassModuleDocCreator moduleDocCreator = new ClassModuleDocCreator();
        this.runtime.injector().injectDependenciesInto((Object)moduleDocCreator);
        ClassesAnalyzer classCodeAnalyzer = new ClassesAnalyzer.Builder().classDocConsumer(moduleDocCreator).build();
        this.runtime.injector().injectDependenciesInto((Object)classCodeAnalyzer);
        classCodeAnalyzer.analyzeCode();
    }

    private void detectPackageInfoModules() {
        PackageInfoModuleDocCreator packageInfoModuleDocCreator = new PackageInfoModuleDocCreator();
        this.runtime.injector().injectDependenciesInto((Object)packageInfoModuleDocCreator);
        PackagesAnalyzer codeAnalyzer = new PackagesAnalyzer.Builder().packageDocConsumer(packageInfoModuleDocCreator).build();
        this.runtime.injector().injectDependenciesInto((Object)codeAnalyzer);
        codeAnalyzer.analyzeCode();
    }

    private void detectModulesComponents() {
        AggregateDocCreator aggregateDocCreator = new AggregateDocCreator(this.environment);
        this.runtime.injector().injectDependenciesInto((Object)aggregateDocCreator);
        ServiceDocCreator serviceDocCreator = new ServiceDocCreator(this.environment);
        this.runtime.injector().injectDependenciesInto((Object)serviceDocCreator);
        EntityDocCreator entityDocCreator = new EntityDocCreator(this.environment);
        this.runtime.injector().injectDependenciesInto((Object)entityDocCreator);
        ValueObjectDocCreator valueObjectDocCreator = new ValueObjectDocCreator(this.environment);
        this.runtime.injector().injectDependenciesInto((Object)valueObjectDocCreator);
        ProcessStepDocCreator messageListenerDocCreator = new ProcessStepDocCreator(this.environment);
        this.runtime.injector().injectDependenciesInto((Object)messageListenerDocCreator);
        ClassesAnalyzer codeAnalyzer = new ClassesAnalyzer.Builder().classDocConsumer(aggregateDocCreator).classDocConsumer(serviceDocCreator).classDocConsumer(entityDocCreator).classDocConsumer(valueObjectDocCreator).classDocConsumer(messageListenerDocCreator).build();
        this.runtime.injector().injectDependenciesInto((Object)codeAnalyzer);
        codeAnalyzer.analyzeCode();
    }

    private void detectDomainProcesses() {
        DomainProcessDocCreator domainProcessDocCreator = new DomainProcessDocCreator(this.environment);
        this.runtime.injector().injectDependenciesInto((Object)domainProcessDocCreator);
        ClassesAnalyzer codeAnalyzer = new ClassesAnalyzer.Builder().classDocConsumer(domainProcessDocCreator).build();
        this.runtime.injector().injectDependenciesInto((Object)codeAnalyzer);
        codeAnalyzer.analyzeCode();
    }

    private void detectRelations() {
        RelationCreator relationCreator = new RelationCreator();
        this.runtime.injector().injectDependenciesInto((Object)relationCreator);
        ClassesAnalyzer codeAnalyzer = new ClassesAnalyzer.Builder().classDocConsumer(relationCreator).build();
        this.runtime.injector().injectDependenciesInto((Object)codeAnalyzer);
        codeAnalyzer.analyzeCode();
    }

    private void createOutputFolder() {
        File outputDirectory = new File(this.configuration.generationConfiguration().outputDirectory());
        outputDirectory.mkdirs();
    }

    private void writeGraphs(Domain domain) {
        GraphImagesWriter graphsWriter = GraphImagesWriter.builder().customDotExecutable(this.configuration.generationConfiguration().customDotExecutable()).customFdpExecutable(this.configuration.generationConfiguration().customFdpExecutable()).outputDirectoryPath(this.configuration.generationConfiguration().outputDirectory()).build();
        graphsWriter.writeImages(domain);
    }

    private void writeHtml(Domain domain) {
        HtmlWriter htmlWriter = new HtmlWriter.Builder().includeGenerationDate(this.configuration.generationConfiguration().includeGenerationDate()).outputDirectoryPath(this.configuration.generationConfiguration().outputDirectory()).build();
        htmlWriter.writeHtml(domain);
    }

    private void writePdf() {
        PdfWriter pdfWriter = new PdfWriter(this.configuration.generationConfiguration());
        pdfWriter.writePdf();
    }
}

