/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.doc.annotations.AnnotationUtils;
import poussecafe.doc.doclet.PathHandler;
import poussecafe.doc.model.DocletAccess;
import poussecafe.doc.model.DocletServices;
import poussecafe.source.Ignore;

public class PathFinder {
    private TypeElement start;
    private Predicate<TypeElement> matcher;
    DocletServices docletServices;
    private String basePackage;
    private Set<String> alreadyExplored = new HashSet<String>();
    private PathHandler pathHandler;

    private PathFinder() {
    }

    public void start() {
        this.explore(this.start);
    }

    public void explore(TypeElement classDoc) {
        TypeMirror returnType;
        DocletAccess docletAccess = this.docletServices.docletAccess();
        PackageElement packageElement = docletAccess.packageElement(classDoc);
        if (!packageElement.getQualifiedName().toString().startsWith(this.basePackage) || this.alreadyExplored.contains(classDoc.getQualifiedName().toString())) {
            return;
        }
        this.alreadyExplored.add(classDoc.getQualifiedName().toString());
        for (ExecutableElement methodDoc : docletAccess.methods(classDoc)) {
            if (!this.isCrawlableMethod(methodDoc)) continue;
            returnType = methodDoc.getReturnType();
            this.tryType(returnType);
        }
        for (VariableElement fieldDoc : docletAccess.fields(classDoc)) {
            if (!this.isCrawlableField(fieldDoc)) continue;
            returnType = fieldDoc.asType();
            this.tryType(returnType);
        }
    }

    private boolean isCrawlableMethod(ExecutableElement methodDoc) {
        return methodDoc.getModifiers().contains((Object)Modifier.PUBLIC) && !this.docletServices.docletAccess().isOverride(methodDoc) && !this.docletServices.annotationsResolver().isIgnored(methodDoc) && AnnotationUtils.annotation(methodDoc, Ignore.class).isEmpty();
    }

    private boolean isCrawlableField(VariableElement methodDoc) {
        return methodDoc.getModifiers().contains((Object)Modifier.PUBLIC) && !this.docletServices.annotationsResolver().isIgnored(methodDoc) && AnnotationUtils.annotation(methodDoc, Ignore.class).isEmpty();
    }

    private void tryType(TypeMirror type) {
        if (!this.tryParametrizedType(type)) {
            this.tryClassDoc(type);
        }
    }

    private boolean tryParametrizedType(TypeMirror returnType) {
        if (returnType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)returnType;
            if (declaredType.getTypeArguments().isEmpty()) {
                return false;
            }
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                this.tryType(typeMirror);
            }
            return true;
        }
        return false;
    }

    private boolean tryClassDoc(TypeMirror type) {
        DocletEnvironment docletEnvironment = this.docletServices.docletEnvironment();
        Element element = docletEnvironment.getTypeUtils().asElement(type);
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            if (docletEnvironment.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString().startsWith(this.basePackage) && this.matcher.test(typeElement)) {
                this.pathHandler.handle(this.start, typeElement);
            } else {
                this.explore(typeElement);
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        private PathFinder pathFinder = new PathFinder();

        public Builder start(TypeElement start) {
            this.pathFinder.start = start;
            return this;
        }

        public Builder basePackage(String basePackage) {
            this.pathFinder.basePackage = basePackage;
            return this;
        }

        public Builder classMatcher(Predicate<TypeElement> matcher) {
            this.pathFinder.matcher = matcher;
            return this;
        }

        public Builder pathHandler(PathHandler pathHandler) {
            this.pathFinder.pathHandler = pathHandler;
            return this;
        }

        public Builder docletServices(DocletServices docletServices) {
            this.pathFinder.docletServices = docletServices;
            return this;
        }

        public PathFinder build() {
            Objects.requireNonNull(this.pathFinder.start);
            Objects.requireNonNull(this.pathFinder.basePackage);
            Objects.requireNonNull(this.pathFinder.matcher);
            Objects.requireNonNull(this.pathFinder.pathHandler);
            Objects.requireNonNull(this.pathFinder.docletServices);
            return this.pathFinder;
        }
    }
}

