/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.DocletEnvironment;
import poussecafe.doc.doclet.Logger;
import poussecafe.doc.model.moduledoc.ModuleDoc;
import poussecafe.doc.model.moduledoc.ModuleDocId;
import poussecafe.doc.model.moduledoc.ModuleDocRepository;

public abstract class ModuleComponentDocCreator
implements Consumer<TypeElement> {
    private DocletEnvironment rootDocWrapper;
    private ModuleDocRepository moduleDocRepository;

    public ModuleComponentDocCreator(DocletEnvironment rootDocWrapper) {
        Objects.requireNonNull(rootDocWrapper);
        this.rootDocWrapper = rootDocWrapper;
    }

    @Override
    public void accept(TypeElement classDoc) {
        if (this.isComponentDoc(classDoc)) {
            Optional<ModuleDoc> moduleDoc = this.moduleDocRepository.findByPackageNamePrefixing(classDoc.getQualifiedName().toString());
            if (moduleDoc.isPresent()) {
                ModuleDocId moduleId = (ModuleDocId)((Object)((ModuleDoc.Attributes)moduleDoc.get().attributes()).identifier().value());
                Logger.debug("Adding " + this.componentName() + " using class " + classDoc.getQualifiedName().toString() + " to BC " + moduleId, new Object[0]);
                this.addDoc(moduleId, classDoc);
            } else {
                Logger.warn("Could not add component with missing bounded context: " + classDoc.getQualifiedName().toString(), new Object[0]);
            }
        }
    }

    protected abstract boolean isComponentDoc(TypeElement var1);

    protected abstract String componentName();

    protected abstract void addDoc(ModuleDocId var1, TypeElement var2);

    protected DocletEnvironment rootDocWrapper() {
        return this.rootDocWrapper;
    }
}

