/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.function.Consumer;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Reporter;
import poussecafe.doc.doclet.Log4jReporter;

public class Logger {
    private static Reporter rootDoc;

    private Logger() {
    }

    public static void setRootDoc(Reporter rootDoc) {
        Logger.rootDoc = rootDoc;
    }

    public static void debug(String message, Object ... args) {
        Logger.log(message, text -> Logger.reporter().print(Diagnostic.Kind.OTHER, (String)text), args);
    }

    public static void warn(String message, Object ... args) {
        Logger.log(message, text -> Logger.reporter().print(Diagnostic.Kind.WARNING, (String)text), args);
    }

    public static void error(String message, Object ... args) {
        Logger.log(message, text -> Logger.reporter().print(Diagnostic.Kind.ERROR, (String)text), args);
    }

    public static void info(String message, Object ... args) {
        Logger.log(message, text -> Logger.reporter().print(Diagnostic.Kind.NOTE, (String)text), args);
    }

    private static Reporter reporter() {
        if (rootDoc == null) {
            rootDoc = new Log4jReporter();
        }
        return rootDoc;
    }

    private static void log(String message, Consumer<String> logger, Object ... args) {
        int i;
        String[] parts = message.split("\\{\\}");
        StringBuilder builder = new StringBuilder();
        int minPartsArgs = Math.min(args.length, parts.length);
        for (i = 0; i < minPartsArgs; ++i) {
            builder.append(parts[i]);
            builder.append(args[i]);
        }
        for (i = args.length; i < parts.length; ++i) {
            builder.append(parts[i]);
        }
        logger.accept(builder.toString());
    }
}

