/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc.doclet;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.lang.model.element.TypeElement;
import poussecafe.doc.annotations.AnnotationUtils;
import poussecafe.doc.model.AnnotationsResolver;
import poussecafe.doc.model.DocletAccess;
import poussecafe.source.Ignore;

public class ClassesAnalyzer {
    private List<Consumer<TypeElement>> classDocConsumers = new ArrayList<Consumer<TypeElement>>();
    private DocletAccess docletAccess;
    private AnnotationsResolver annotationsResolver;

    private ClassesAnalyzer() {
    }

    public void analyzeCode() {
        for (TypeElement classDoc : this.docletAccess.typeElements()) {
            if (this.annotationsResolver.isIgnored(classDoc) || !AnnotationUtils.annotation(classDoc, Ignore.class).isEmpty()) continue;
            this.processClassDoc(classDoc);
        }
    }

    private void processClassDoc(TypeElement classDoc) {
        for (Consumer<TypeElement> consumer : this.classDocConsumers) {
            consumer.accept(classDoc);
        }
    }

    public static class Builder {
        private ClassesAnalyzer analyzer = new ClassesAnalyzer();

        public Builder classDocConsumer(Consumer<TypeElement> classDocConsumer) {
            Objects.requireNonNull(classDocConsumer);
            this.analyzer.classDocConsumers.add(classDocConsumer);
            return this;
        }

        public ClassesAnalyzer build() {
            return this.analyzer;
        }
    }
}

