/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.model.ComponentType;
import poussecafe.source.model.SourceModel;
import poussecafe.source.model.TypeComponent;
import poussecafe.source.model.TypeReference;

public class ReferenceGraphExplorer {
    private List<TypeReference> entryPoint;
    private Predicate<TypeReference> matcher;
    private List<TypeReference> matches = new ArrayList<TypeReference>();
    private Set<TypeReference> alreadyExplored = new HashSet<TypeReference>();
    private SourceModel model;

    public void explore() {
        this.explore(this.entryPoint);
    }

    private void explore(List<TypeReference> references) {
        references.forEach(this::explore);
    }

    public List<TypeReference> matches() {
        return Collections.unmodifiableList(this.matches);
    }

    private void explore(TypeReference reference) {
        if (!this.alreadyExplored.contains(reference)) {
            this.alreadyExplored.add(reference);
            if (this.matcher.test(reference)) {
                this.matches.add(reference);
            }
            List<TypeReference> nextReferences = this.getReferences(reference);
            this.explore(nextReferences);
        }
    }

    private List<TypeReference> getReferences(TypeReference reference) {
        if (reference.type() == ComponentType.VALUE_OBJECT) {
            return this.typeReferences(reference.typeClassName(), this.model.valueObjects());
        }
        if (reference.type() == ComponentType.ENTITY) {
            return this.typeReferences(reference.typeClassName(), this.model.entities());
        }
        throw new IllegalArgumentException("Unsupported component type " + reference.type());
    }

    private List<TypeReference> typeReferences(ClassName expectedClassName, List<TypeComponent> components) {
        TypeComponent valueObject = components.stream().filter(candidate -> expectedClassName.equals((Object)candidate.typeName().asName())).findFirst().orElseThrow();
        return valueObject.references();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ReferenceGraphExplorer() {
    }

    public static class Builder {
        private ReferenceGraphExplorer explorer = new ReferenceGraphExplorer();

        public ReferenceGraphExplorer build() {
            Objects.requireNonNull(this.explorer.model);
            Objects.requireNonNull(this.explorer.entryPoint);
            Objects.requireNonNull(this.explorer.matcher);
            return this.explorer;
        }

        public Builder entryPoint(List<TypeReference> entryPoint) {
            this.explorer.entryPoint = new ArrayList<TypeReference>();
            this.explorer.entryPoint.addAll(entryPoint);
            return this;
        }

        public Builder matcher(Predicate<TypeReference> matcher) {
            this.explorer.matcher = matcher;
            return this;
        }

        public Builder model(SourceModel model) {
            this.explorer.model = model;
            return this;
        }

        private Builder() {
        }
    }
}

